/*
 * Decompiled with CFR 0.152.
 */
package com.codehusky.huskyui.states.action;

import com.codehusky.huskyui.StateContainer;
import com.codehusky.huskyui.states.action.Action;
import com.codehusky.huskyui.states.action.ActionType;
import javax.annotation.Nonnull;
import org.spongepowered.api.Sponge;
import org.spongepowered.api.command.CommandSource;
import org.spongepowered.api.item.inventory.Inventory;

public class CommandAction
extends Action {
    @Nonnull
    private final String command;
    @Nonnull
    private CommandReceiver receiver;

    public CommandAction(@Nonnull StateContainer container, @Nonnull ActionType type, @Nonnull String goalState, @Nonnull String command) {
        super(container, type, goalState);
        this.command = command;
        this.receiver = CommandReceiver.SERVER;
    }

    public CommandAction(@Nonnull StateContainer container, @Nonnull ActionType type, @Nonnull String goalState, @Nonnull String command, @Nonnull CommandReceiver receiver) {
        super(container, type, goalState);
        this.command = command;
        this.receiver = receiver;
    }

    @Override
    public void runAction(@Nonnull String currentState, Inventory inventory) {
        Sponge.getCommandManager().process((CommandSource)(this.receiver == CommandReceiver.SERVER ? Sponge.getServer().getConsole() : this.getObserver()), this.command);
        super.runAction(currentState, inventory);
    }

    @Nonnull
    public String getCommand() {
        return this.command;
    }

    @Nonnull
    public CommandReceiver getReceiver() {
        return this.receiver;
    }

    public void setReceiver(@Nonnull CommandReceiver receiver) {
        this.receiver = receiver;
    }

    @Override
    @Nonnull
    public Action copy(@Nonnull StateContainer newContainer) {
        return new CommandAction(newContainer, this.getType(), this.getGoalState(), this.command, this.receiver);
    }

    public static enum CommandReceiver {
        PLAYER,
        SERVER;

    }
}

