/*
 * Decompiled with CFR 0.152.
 */
package com.codehusky.huskyui.states.action.runnable;

import com.codehusky.huskyui.StateContainer;
import com.codehusky.huskyui.states.action.Action;
import com.codehusky.huskyui.states.action.ActionType;
import com.codehusky.huskyui.states.action.runnable.UIRunnable;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.spongepowered.api.item.inventory.Inventory;
import org.spongepowered.api.text.Text;
import org.spongepowered.api.text.format.TextColors;

public class RunnableAction
extends Action {
    @Nullable
    private UIRunnable runnable;

    public RunnableAction(@Nonnull StateContainer container, @Nonnull ActionType type, @Nonnull String goalState) {
        this(container, type, goalState, null);
    }

    public RunnableAction(@Nonnull StateContainer container, @Nonnull ActionType type, @Nonnull String goalState, @Nullable UIRunnable runnable) {
        super(container, type, goalState);
        this.runnable = runnable;
    }

    @Nullable
    public UIRunnable getRunnable() {
        return this.runnable;
    }

    public void setRunnable(@Nonnull UIRunnable runnable) {
        this.runnable = runnable;
    }

    @Override
    public void runAction(@Nonnull String currentState, Inventory inventory) {
        if (this.runnable != null) {
            this.runnable.run(this);
        } else {
            this.getObserver().sendMessage(Text.of((Object[])new Object[]{TextColors.RED, "Cannot run a null action!"}));
        }
        super.runAction(currentState, inventory);
    }

    @Override
    @Nonnull
    public RunnableAction copy(@Nonnull StateContainer newContainer) {
        return new RunnableAction(newContainer, this.getType(), this.getGoalState(), this.runnable);
    }
}

