/*
 * Decompiled with CFR 0.152.
 */
package flavor.pie.react;

import com.google.common.reflect.TypeToken;
import java.math.BigDecimal;
import java.util.Collections;
import java.util.List;
import ninja.leaping.configurate.objectmapping.Setting;
import ninja.leaping.configurate.objectmapping.serialize.ConfigSerializable;
import org.spongepowered.api.Sponge;
import org.spongepowered.api.service.economy.Currency;
import org.spongepowered.api.text.Text;
import org.spongepowered.api.text.format.TextColors;

@ConfigSerializable
public class Config {
    public static final TypeToken<Config> type = TypeToken.of(Config.class);
    @Setting
    public Text text = Text.of((Object[])new Object[]{TextColors.YELLOW, "Hover over this text to see a word. The first person to type it wins!"});
    @Setting
    public Text prefix = Text.EMPTY;
    @Setting
    public Text suffix = Text.EMPTY;
    @Setting
    public List<String> words = Collections.emptyList();
    @Setting
    public int delay = 300;
    @Setting(value="max-delay")
    public int maxDelay = 0;
    @Setting(value="min-players")
    public int minPlayers = 5;
    @Setting
    public RewardsBlock rewards = new RewardsBlock();

    @ConfigSerializable
    public static class EconomySection {
        @Setting(value="currency")
        private String currencyString;
        private Currency currency;
        @Setting
        public BigDecimal amount = BigDecimal.ZERO;

        public Currency getCurrency() {
            if (this.currency == null) {
                this.currency = (Currency)Sponge.getRegistry().getType(Currency.class, this.currencyString).get();
            }
            return this.currency;
        }
    }

    @ConfigSerializable
    public static class RewardsBlock {
        @Setting
        public EconomySection economy = new EconomySection();
        @Setting
        public List<String> commands = Collections.emptyList();
    }
}

