/*
 * Decompiled with CFR 0.152.
 */
package flavor.pie.react;

import com.google.common.reflect.TypeToken;
import com.google.inject.Inject;
import flavor.pie.react.BigDecimalSerializer;
import flavor.pie.react.Config;
import flavor.pie.react.ReactData;
import flavor.pie.react.ReactKeys;
import java.io.IOException;
import java.math.BigDecimal;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.time.Instant;
import java.util.Random;
import java.util.concurrent.TimeUnit;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import ninja.leaping.configurate.ConfigurationNode;
import ninja.leaping.configurate.commented.CommentedConfigurationNode;
import ninja.leaping.configurate.hocon.HoconConfigurationLoader;
import ninja.leaping.configurate.loader.ConfigurationLoader;
import ninja.leaping.configurate.objectmapping.ObjectMappingException;
import ninja.leaping.configurate.objectmapping.serialize.TypeSerializer;
import ninja.leaping.configurate.objectmapping.serialize.TypeSerializers;
import org.bstats.sponge.MetricsLite2;
import org.slf4j.Logger;
import org.spongepowered.api.Game;
import org.spongepowered.api.GameState;
import org.spongepowered.api.asset.Asset;
import org.spongepowered.api.command.CommandCallable;
import org.spongepowered.api.command.CommandException;
import org.spongepowered.api.command.CommandManager;
import org.spongepowered.api.command.CommandResult;
import org.spongepowered.api.command.CommandSource;
import org.spongepowered.api.command.args.CommandContext;
import org.spongepowered.api.command.args.GenericArguments;
import org.spongepowered.api.command.spec.CommandSpec;
import org.spongepowered.api.config.DefaultConfig;
import org.spongepowered.api.data.DataRegistration;
import org.spongepowered.api.data.manipulator.DataManipulatorBuilder;
import org.spongepowered.api.data.value.ValueContainer;
import org.spongepowered.api.entity.living.player.Player;
import org.spongepowered.api.event.Listener;
import org.spongepowered.api.event.filter.Getter;
import org.spongepowered.api.event.filter.cause.First;
import org.spongepowered.api.event.filter.data.Has;
import org.spongepowered.api.event.game.GameReloadEvent;
import org.spongepowered.api.event.game.state.GameInitializationEvent;
import org.spongepowered.api.event.game.state.GamePreInitializationEvent;
import org.spongepowered.api.event.message.MessageChannelEvent;
import org.spongepowered.api.event.network.ClientConnectionEvent;
import org.spongepowered.api.plugin.Plugin;
import org.spongepowered.api.plugin.PluginContainer;
import org.spongepowered.api.scheduler.Task;
import org.spongepowered.api.service.economy.EconomyService;
import org.spongepowered.api.text.Text;
import org.spongepowered.api.text.action.HoverAction;
import org.spongepowered.api.text.action.TextActions;

@Plugin(id="react", name="React", description="A little game to be played in chat.", authors={"pie_flavor"}, version="1.3.2")
public class React {
    @Inject
    Game game;
    @Inject
    PluginContainer container;
    @Inject
    @DefaultConfig(sharedRoot=true)
    Path path;
    @Inject
    @DefaultConfig(sharedRoot=true)
    ConfigurationLoader<CommentedConfigurationNode> loader;
    @Inject
    Logger logger;
    @Inject
    MetricsLite2 metrics;
    Config config;
    boolean inGame;
    String current;
    Task task;
    Random random;
    Instant started;
    private static final Pattern ASTERISK = Pattern.compile("^\\*");
    private static final Pattern WINNER = Pattern.compile("$winner", 16);

    @Listener
    public void preInit(GamePreInitializationEvent e) throws IOException, ObjectMappingException {
        TypeSerializers.getDefaultSerializers().registerType(TypeToken.of(BigDecimal.class), (TypeSerializer)new BigDecimalSerializer());
        this.random = new Random();
        this.loadConfig();
        DataRegistration.builder().dataClass(ReactData.class).immutableClass(ReactData.Immutable.class).builder((DataManipulatorBuilder)new ReactData.Builder()).manipulatorId("react_data").dataName("ReactData").buildAndRegister(this.container);
    }

    @Listener
    public void init(GameInitializationEvent e) {
        CommandSpec wins = CommandSpec.builder().arguments(GenericArguments.playerOrSource((Text)Text.of((String)"player"))).executor(this::wins).description((Text)Text.of((String)"Gets a player's win count")).build();
        this.game.getCommandManager().register((Object)this, (CommandCallable)wins, new String[]{"wins"});
    }

    private void loadConfig() throws IOException, ObjectMappingException {
        if (!Files.exists(this.path, new LinkOption[0])) {
            ((Asset)this.game.getAssetManager().getAsset((Object)this, "default.conf").get()).copyToFile(this.path);
        }
        ConfigurationNode root = this.loader.load();
        this.updateConfig(root);
        this.config = (Config)root.getValue(Config.type);
        if (this.task != null) {
            this.task.cancel();
        }
        this.scheduleGame();
    }

    private void updateConfig(ConfigurationNode root) throws IOException, ObjectMappingException {
        int version = root.getNode(new Object[]{"version"}).getInt();
        if (version < 3) {
            HoconConfigurationLoader assetLoader = ((HoconConfigurationLoader.Builder)HoconConfigurationLoader.builder().setURL(((Asset)this.game.getAssetManager().getAsset((Object)this, "default.conf").get()).getUrl())).build();
            ConfigurationNode assetRoot = assetLoader.load();
            if (version < 2) {
                root.getNode(new Object[]{"rewards"}).setValue(assetRoot.getNode(new Object[]{"rewards"}).getValue());
                root.getNode(new Object[]{"version"}).setValue((Object)2);
            }
            root.getNode(new Object[]{"min-players"}).setValue(assetRoot.getNode(new Object[]{"min-players"}).getValue());
            root.getNode(new Object[]{"version"}).setValue((Object)3);
            this.loader.save(root);
        }
    }

    @Listener
    public void reload(GameReloadEvent e) throws IOException, ObjectMappingException {
        this.loadConfig();
    }

    private void newGame() {
        if (!this.game.getState().equals((Object)GameState.SERVER_STARTED) || this.config.minPlayers > this.game.getServer().getOnlinePlayers().size()) {
            return;
        }
        this.inGame = true;
        this.current = this.config.words.get(this.random.nextInt(this.config.words.size()));
        Text fullText = this.config.text.toBuilder().onHover((HoverAction)TextActions.showText((Text)Text.of((String)this.current.trim()))).build();
        Text toShow = this.config.prefix.concat(fullText).concat(this.config.suffix);
        this.game.getServer().getBroadcastChannel().send(toShow);
        this.started = Instant.now();
        this.scheduleGame();
    }

    private void scheduleGame() {
        this.task = Task.builder().execute(this::newGame).delay((long)this.getDelay(), TimeUnit.SECONDS).submit((Object)this);
    }

    @Listener
    public void chat(MessageChannelEvent.Chat e, @First Player p) {
        String chat = e.getRawMessage().toPlain().trim();
        if (this.inGame && chat.equalsIgnoreCase(this.current)) {
            this.game.getServer().getBroadcastChannel().send((Text)Text.of((String)(p.getName() + " has won! Time: " + (Instant.now().getEpochSecond() - this.started.getEpochSecond()) + " seconds!")));
            this.inGame = false;
            this.config.rewards.commands.forEach(s -> this.game.getCommandManager().process((CommandSource)(s.startsWith("*") ? this.game.getServer().getConsole() : p), WINNER.matcher(ASTERISK.matcher((CharSequence)s).replaceAll("")).replaceAll(Matcher.quoteReplacement(p.getName()))));
            this.game.getServiceManager().provide(EconomyService.class).ifPresent(svc -> {
                if (this.config.rewards.economy.amount.compareTo(BigDecimal.ZERO) > 0) {
                    svc.getOrCreateAccount(p.getUniqueId()).ifPresent(acc -> acc.deposit(this.config.rewards.economy.getCurrency(), this.config.rewards.economy.amount, this.game.getCauseStackManager().getCurrentCause()));
                }
            });
            p.offer(ReactKeys.GAMES_WON, (Object)((Long)p.get(ReactKeys.GAMES_WON).get() + 1L));
        }
    }

    private void disable() {
        this.game.getEventManager().unregisterPluginListeners((Object)this);
        this.game.getCommandManager().getOwnedBy((Object)this).forEach(arg_0 -> ((CommandManager)this.game.getCommandManager()).removeMapping(arg_0));
    }

    @Listener
    public void onJoin(ClientConnectionEvent.Join e, @Getter(value="getTargetEntity") @Has(value=ReactData.class, inverse=true) Player p) {
        ReactData data = (ReactData)((Object)p.getOrCreate(ReactData.class).get());
        p.offer((ValueContainer)data);
    }

    public CommandResult wins(CommandSource src, CommandContext args) throws CommandException {
        Player p = (Player)args.getOne("player").get();
        long wins = (Long)p.get(ReactKeys.GAMES_WON).get();
        src.sendMessage(Text.of((Object[])new Object[]{"Player ", p.getName(), " has won ", wins, " times."}));
        return CommandResult.builder().successCount(Integer.valueOf(1)).queryResult(Integer.valueOf(wins > Integer.MAX_VALUE ? Integer.MAX_VALUE : (int)wins)).build();
    }

    private int getDelay() {
        if (this.config.maxDelay <= this.config.delay) {
            return this.config.delay;
        }
        return this.random.nextInt(this.config.maxDelay - this.config.delay + 1) + this.config.delay;
    }
}

