/*
 * Decompiled with CFR 0.152.
 */
package io.github.mrdarcychen;

import com.google.common.reflect.TypeToken;
import com.google.inject.Inject;
import io.github.mrdarcychen.arenas.ArenaManager;
import io.github.mrdarcychen.arenas.SpawnPoint;
import io.github.mrdarcychen.arenas.SpawnSerializer;
import io.github.mrdarcychen.listeners.ClientConnectionEventListener;
import io.github.mrdarcychen.listeners.EntityListener;
import io.github.mrdarcychen.listeners.ServerListener;
import io.github.mrdarcychen.managers.CommandManager;
import io.github.mrdarcychen.managers.ConfigManager;
import io.github.mrdarcychen.utils.Kit;
import io.github.mrdarcychen.utils.KitManager;
import io.github.mrdarcychen.utils.KitSerializer;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.Arrays;
import java.util.List;
import ninja.leaping.configurate.objectmapping.serialize.TypeSerializer;
import ninja.leaping.configurate.objectmapping.serialize.TypeSerializers;
import org.slf4j.Logger;
import org.spongepowered.api.Sponge;
import org.spongepowered.api.config.ConfigDir;
import org.spongepowered.api.config.DefaultConfig;
import org.spongepowered.api.event.Listener;
import org.spongepowered.api.event.game.state.GamePreInitializationEvent;
import org.spongepowered.api.event.game.state.GameStartingServerEvent;
import org.spongepowered.api.plugin.Plugin;

@Plugin(id="blockyarena", name="BlockyArena")
public final class BlockyArena {
    private static BlockyArena PLUGIN;
    @Inject
    private Logger logger;
    @Inject
    @ConfigDir(sharedRoot=false)
    private Path configDir;
    private Path arenaDir;
    private Path kitDir;
    @Inject
    @DefaultConfig(sharedRoot=false)
    private Path defaultConfig;

    @Inject
    private BlockyArena() {
    }

    @Listener
    public void onPreInit(GamePreInitializationEvent event) {
        PLUGIN = this;
        this.registerTypeSerializers();
        this.registerListeners();
        this.createDirectories();
    }

    @Listener
    public void onServerStarting(GameStartingServerEvent event) {
        CommandManager.getInstance().registerCommands();
        ConfigManager.getInstance().load();
        ArenaManager am = ArenaManager.getInstance();
        am.loadArenas();
        KitManager.getInstance().loadKits();
    }

    private void createDirectories() {
        this.arenaDir = Paths.get(this.getConfigDir().toString() + "/arenas", new String[0]);
        this.kitDir = Paths.get(this.getConfigDir().toString() + "/kits", new String[0]);
        List<Path> directories = Arrays.asList(this.arenaDir, this.kitDir);
        for (Path dir : directories) {
            try {
                if (dir.toFile().exists()) continue;
                Files.createDirectory(dir, new FileAttribute[0]);
            }
            catch (IOException e) {
                this.logger.warn("Error creating directory for " + dir.getFileName().toString());
            }
        }
    }

    private void registerListeners() {
        Sponge.getEventManager().registerListeners((Object)this, (Object)new EntityListener());
        Sponge.getEventManager().registerListeners((Object)this, (Object)new ClientConnectionEventListener());
        Sponge.getEventManager().registerListeners((Object)this, (Object)new ServerListener());
    }

    private void registerTypeSerializers() {
        TypeSerializers.getDefaultSerializers().registerType(TypeToken.of(SpawnPoint.class), (TypeSerializer)new SpawnSerializer(this));
        TypeSerializers.getDefaultSerializers().registerType(TypeToken.of(Kit.class), (TypeSerializer)new KitSerializer(this));
    }

    public Logger getLogger() {
        return this.logger;
    }

    public Path getDefaultConfig() {
        return this.defaultConfig;
    }

    public Path getConfigDir() {
        return this.configDir;
    }

    public Path getArenaDir() {
        return this.arenaDir;
    }

    public Path getKitDir() {
        return this.kitDir;
    }

    public static BlockyArena getInstance() {
        return PLUGIN;
    }
}

