/*
 * Decompiled with CFR 0.152.
 */
package io.github.mrdarcychen.arenas;

import io.github.mrdarcychen.arenas.SpawnPoint;
import java.util.ArrayDeque;
import java.util.Deque;
import java.util.stream.Stream;

public class Arena {
    private String name;
    private Deque<SpawnPoint> startPoints;
    private SpawnPoint lobbySpawn;
    private SpawnPoint spectatorSpawn;
    private boolean isBusy = false;

    private Arena(String name, SpawnPoint lobbySpawn, SpawnPoint spectatorSpawn, Deque<SpawnPoint> startPoints) {
        this.name = name;
        this.lobbySpawn = lobbySpawn;
        this.spectatorSpawn = spectatorSpawn;
        this.startPoints = startPoints;
    }

    public Stream<SpawnPoint> getStartPoints() {
        return this.startPoints.stream();
    }

    public SpawnPoint getLobbySpawn() {
        return this.lobbySpawn;
    }

    public SpawnPoint getSpectatorSpawn() {
        return this.spectatorSpawn;
    }

    public void setBusy(boolean isBusy) {
        this.isBusy = isBusy;
    }

    public boolean isBusy() {
        return this.isBusy;
    }

    public String getName() {
        return this.name;
    }

    public static class Builder {
        private Deque<SpawnPoint> startPoints = new ArrayDeque<SpawnPoint>();
        private SpawnPoint lobbySpawn;
        private SpawnPoint spectatorSpawn = this.lobbySpawn;
        private String name;

        public Builder(String name) {
            this.name = name;
        }

        public Builder addStartPoint(SpawnPoint spawnPoint) {
            this.startPoints.add(spawnPoint);
            return this;
        }

        public Builder undo() {
            this.startPoints.pollLast();
            return this;
        }

        public Builder setLobbySpawn(SpawnPoint spawnPoint) {
            this.lobbySpawn = spawnPoint;
            return this;
        }

        public Builder setSpectatorSpawn(SpawnPoint spawnPoint) {
            this.spectatorSpawn = spawnPoint;
            return this;
        }

        public int getStartPointCount() {
            return this.startPoints.size();
        }

        public Arena build() {
            if (this.lobbySpawn == null || this.spectatorSpawn == null) {
                throw new IllegalStateException("missing lobby spawn or spectator spawn.");
            }
            if (this.startPoints.size() < 2) {
                throw new IllegalStateException("there must be at least 2 start points.");
            }
            return new Arena(this.name, this.lobbySpawn, this.spectatorSpawn, this.startPoints);
        }
    }
}

