/*
 * Decompiled with CFR 0.152.
 */
package io.github.mrdarcychen.arenas;

import com.google.common.reflect.TypeToken;
import io.github.mrdarcychen.BlockyArena;
import io.github.mrdarcychen.arenas.Arena;
import io.github.mrdarcychen.arenas.SpawnPoint;
import java.io.File;
import java.io.IOException;
import java.nio.file.DirectoryStream;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import ninja.leaping.configurate.ConfigurationNode;
import ninja.leaping.configurate.hocon.HoconConfigurationLoader;
import ninja.leaping.configurate.objectmapping.ObjectMappingException;

public class ArenaManager {
    private static ArenaManager INSTANCE;
    private List<Arena> arenas = new ArrayList<Arena>();
    private Path configDir = BlockyArena.getInstance().getArenaDir();

    public ArenaManager() {
        this.loadArenas();
    }

    public static ArenaManager getInstance() {
        if (INSTANCE == null) {
            INSTANCE = new ArenaManager();
        }
        return INSTANCE;
    }

    public void loadArenas() {
        try {
            DirectoryStream<Path> stream = Files.newDirectoryStream(BlockyArena.getInstance().getArenaDir(), "*.conf");
            for (Path file : stream) {
                HoconConfigurationLoader loader = ((HoconConfigurationLoader.Builder)HoconConfigurationLoader.builder().setPath(file)).build();
                try {
                    ConfigurationNode rootNode = loader.load();
                    String name = rootNode.getNode(new Object[]{"name"}).getString();
                    Arena.Builder builder = new Arena.Builder(name);
                    builder.setLobbySpawn((SpawnPoint)rootNode.getNode(new Object[]{"lobbySpawn"}).getValue(TypeToken.of(SpawnPoint.class)));
                    builder.setSpectatorSpawn((SpawnPoint)rootNode.getNode(new Object[]{"spectatorSpawn"}).getValue(TypeToken.of(SpawnPoint.class)));
                    for (ConfigurationNode node : rootNode.getNode(new Object[]{"startPoints"}).getChildrenList()) {
                        builder.addStartPoint((SpawnPoint)node.getValue(TypeToken.of(SpawnPoint.class)));
                    }
                    loader.save(rootNode);
                    Arena arena = builder.build();
                    this.arenas.add(arena);
                }
                catch (ObjectMappingException e) {
                    BlockyArena.getInstance().getLogger().warn("Error reading arena config.");
                }
            }
        }
        catch (IOException e) {
            BlockyArena.getInstance().getLogger().warn("Error loading existing arena configs.");
        }
    }

    public Optional<Arena> findArena() {
        return this.arenas.stream().filter(it -> !it.isBusy()).findAny();
    }

    public Optional<Arena> findArena(String mode) {
        Predicate<Arena> criteria;
        switch (mode.toLowerCase()) {
            case "1v1": 
            case "2v2": {
                criteria = it -> !it.isBusy();
                break;
            }
            case "ffa": {
                criteria = it -> !it.isBusy() && it.getStartPoints().count() > 2L;
                break;
            }
            default: {
                criteria = it -> false;
            }
        }
        return this.arenas.stream().filter(criteria).findAny();
    }

    public Optional<Arena> getArena(String name) {
        return this.arenas.stream().filter(it -> it.getName().equals(name)).findFirst();
    }

    public void add(Arena arena) {
        Path file = Paths.get(this.configDir.toString() + File.separator + arena.getName() + ".conf", new String[0]);
        try {
            if (!file.toFile().exists()) {
                Files.createFile(file, new FileAttribute[0]);
            }
        }
        catch (IOException e) {
            BlockyArena.getInstance().getLogger().warn("Error creating arena config file for " + arena.getName());
            return;
        }
        HoconConfigurationLoader loader = ((HoconConfigurationLoader.Builder)HoconConfigurationLoader.builder().setPath(file)).build();
        try {
            ConfigurationNode rootNode = loader.load();
            rootNode.getNode(new Object[]{"name"}).setValue((Object)arena.getName());
            List startPoints = arena.getStartPoints().collect(Collectors.toList());
            for (int i = 0; i < startPoints.size(); ++i) {
                rootNode.getNode(new Object[]{"startPoints"}).getNode(new Object[]{i}).setValue(TypeToken.of(SpawnPoint.class), startPoints.get(i));
            }
            rootNode.getNode(new Object[]{"lobbySpawn"}).setValue(TypeToken.of(SpawnPoint.class), (Object)arena.getLobbySpawn());
            rootNode.getNode(new Object[]{"spectatorSpawn"}).setValue(TypeToken.of(SpawnPoint.class), (Object)arena.getSpectatorSpawn());
            loader.save(rootNode);
        }
        catch (IOException | ObjectMappingException e) {
            BlockyArena.getInstance().getLogger().warn("Error writing arena config.");
        }
        this.arenas.add(arena);
    }

    public void remove(String name) {
        this.arenas.removeIf(it -> it.getName().equals(name));
        Path path = Paths.get(this.configDir.toString() + File.separator + name + ".conf", new String[0]);
        try {
            Files.delete(path);
        }
        catch (IOException e) {
            throw new IllegalArgumentException(name + " does not exist.");
        }
    }
}

