/*
 * Decompiled with CFR 0.152.
 */
package io.github.mrdarcychen.arenas;

import com.flowpowered.math.vector.Vector3d;
import com.google.common.reflect.TypeToken;
import io.github.mrdarcychen.BlockyArena;
import io.github.mrdarcychen.arenas.SpawnPoint;
import java.util.UUID;
import ninja.leaping.configurate.ConfigurationNode;
import ninja.leaping.configurate.objectmapping.ObjectMappingException;
import ninja.leaping.configurate.objectmapping.serialize.TypeSerializer;
import org.spongepowered.api.Sponge;
import org.spongepowered.api.entity.Transform;
import org.spongepowered.api.world.World;
import org.spongepowered.api.world.extent.Extent;

public class SpawnSerializer
implements TypeSerializer<SpawnPoint> {
    public static BlockyArena plugin;

    public SpawnSerializer(BlockyArena plugin) {
        SpawnSerializer.plugin = plugin;
    }

    public SpawnPoint deserialize(TypeToken<?> type, ConfigurationNode value) throws ObjectMappingException {
        UUID extentUUID = (UUID)value.getNode(new Object[]{"extent"}).getValue(TypeToken.of(UUID.class));
        if (!Sponge.getServer().getWorld(extentUUID).isPresent()) {
            plugin.getLogger().warn("Cannot find extent with UUID " + extentUUID.toString());
        }
        World extent = (World)Sponge.getServer().getWorld(extentUUID).get();
        Vector3d position = (Vector3d)value.getNode(new Object[]{"position"}).getValue(TypeToken.of(Vector3d.class));
        Vector3d rotation = (Vector3d)value.getNode(new Object[]{"rotation"}).getValue(TypeToken.of(Vector3d.class));
        return SpawnPoint.of((Transform<World>)new Transform((Extent)extent, position, rotation));
    }

    public void serialize(TypeToken<?> type, SpawnPoint obj, ConfigurationNode value) throws ObjectMappingException {
        Transform<World> transform = obj.getTransform();
        value.getNode(new Object[]{"extent"}).setValue(TypeToken.of(UUID.class), (Object)((World)transform.getExtent()).getUniqueId());
        value.getNode(new Object[]{"position"}).setValue(TypeToken.of(Vector3d.class), (Object)transform.getPosition());
        value.getNode(new Object[]{"rotation"}).setValue(TypeToken.of(Vector3d.class), (Object)transform.getRotation());
    }
}

