/*
 * Decompiled with CFR 0.152.
 */
package io.github.mrdarcychen.commands;

import io.github.mrdarcychen.commands.CmdEdit;
import io.github.mrdarcychen.utils.Kit;
import io.github.mrdarcychen.utils.KitManager;
import org.spongepowered.api.command.CommandException;
import org.spongepowered.api.command.CommandResult;
import org.spongepowered.api.command.CommandSource;
import org.spongepowered.api.command.args.CommandContext;
import org.spongepowered.api.command.spec.CommandExecutor;
import org.spongepowered.api.entity.living.player.Player;
import org.spongepowered.api.text.Text;

public class CmdCreate
implements CommandExecutor {
    private static final CmdCreate INSTANCE = new CmdCreate();

    private CmdCreate() {
    }

    public static CmdCreate getInstance() {
        return INSTANCE;
    }

    public CommandResult execute(CommandSource src, CommandContext args) throws CommandException {
        if (!(src instanceof Player)) {
            src.sendMessage((Text)Text.of((String)"This command must be executed by a player."));
            return CommandResult.empty();
        }
        Player player = (Player)src;
        String type = (String)args.getOne("type").get();
        String id = (String)args.getOne("id").get();
        switch (type) {
            case "arena": {
                CmdEdit.getInstance().expectBuilder(player, id);
                player.sendMessage((Text)Text.of((String)("Start configuring interactively with /ba edit " + id + " spawn <type>.")));
                player.sendMessage((Text)Text.of((String)"For detailed instructions, please visit the GitHub repo."));
                player.sendMessage((Text)Text.of((String)("Execute /ba edit " + id + " save when you're done.")));
                player.sendMessage((Text)Text.of((String)("Execute /ba create arena " + id + " to start over.")));
                return CommandResult.success();
            }
            case "kit": {
                Kit kit = new Kit(player, id);
                KitManager.getInstance().add(kit, id);
                player.sendMessage((Text)Text.of((String)("A new kit has been created, and players will be able to retrieve an exact copy of your current inventory with /ba kit " + id + " when they're in an active game session. To overwrite, simply execute this command again with the same id.")));
                return CommandResult.success();
            }
        }
        player.sendMessage((Text)Text.of((String)"Invalid argument <type>. Must be either arena or kit."));
        return CommandResult.empty();
    }
}

