/*
 * Decompiled with CFR 0.152.
 */
package io.github.mrdarcychen.commands;

import io.github.mrdarcychen.arenas.Arena;
import io.github.mrdarcychen.arenas.ArenaManager;
import io.github.mrdarcychen.arenas.SpawnPoint;
import java.util.HashMap;
import java.util.Map;
import org.spongepowered.api.command.CommandException;
import org.spongepowered.api.command.CommandResult;
import org.spongepowered.api.command.CommandSource;
import org.spongepowered.api.command.args.CommandContext;
import org.spongepowered.api.command.spec.CommandExecutor;
import org.spongepowered.api.entity.Transform;
import org.spongepowered.api.entity.living.player.Player;
import org.spongepowered.api.text.Text;
import org.spongepowered.api.world.World;

public class CmdEdit
implements CommandExecutor {
    private static final CmdEdit INSTANCE = new CmdEdit();
    private Map<Player, Arena.Builder> builders = new HashMap<Player, Arena.Builder>();

    private CmdEdit() {
    }

    public static CmdEdit getInstance() {
        return INSTANCE;
    }

    public CommandResult execute(CommandSource src, CommandContext args) throws CommandException {
        Player player = (Player)src;
        String id = (String)args.getOne("id").get();
        String type = (String)args.getOne("type").get();
        String param = args.getOne("param").orElse("");
        Arena.Builder builder = this.builders.get(player);
        if (builder == null) {
            player.sendMessage((Text)Text.of((String)("Arena " + id + " does not exist.")));
            return CommandResult.empty();
        }
        if ("save".equals(type)) {
            Arena arena;
            try {
                arena = builder.build();
            }
            catch (IllegalStateException e) {
                player.sendMessage((Text)Text.of((String)("Saving failed: " + e.getMessage())));
                return CommandResult.empty();
            }
            ArenaManager.getInstance().add(arena);
            player.sendMessage((Text)Text.of((String)("Success! Arena " + arena.getName() + " is now in operation.")));
        } else {
            switch (param) {
                case "start": {
                    builder.addStartPoint(SpawnPoint.of((Transform<World>)player.getTransform()));
                    player.sendMessage((Text)Text.of((String)("Start point for team #" + builder.getStartPointCount() + " has been added to " + id + ".")));
                    break;
                }
                case "lobby": {
                    builder.setLobbySpawn(SpawnPoint.of((Transform<World>)player.getTransform()));
                    player.sendMessage((Text)Text.of((String)("Lobby spawn point has been set for " + id + ".")));
                    break;
                }
                case "spectator": {
                    builder.setSpectatorSpawn(SpawnPoint.of((Transform<World>)player.getTransform()));
                    player.sendMessage((Text)Text.of((String)("Spectator spawn point has been set for " + id + ".")));
                    break;
                }
                default: {
                    player.sendMessage((Text)Text.of((String)"<type> must be lobby, spectator, or start."));
                    return CommandResult.empty();
                }
            }
        }
        return CommandResult.success();
    }

    public void expectBuilder(Player player, String arenaName) {
        Arena.Builder builder = new Arena.Builder(arenaName);
        this.builders.put(player, builder);
    }
}

