/*
 * Decompiled with CFR 0.152.
 */
package io.github.mrdarcychen.commands;

import io.github.mrdarcychen.games.Game;
import io.github.mrdarcychen.games.GameManager;
import io.github.mrdarcychen.games.GamersManager;
import io.github.mrdarcychen.utils.Gamer;
import java.util.Optional;
import org.spongepowered.api.command.CommandException;
import org.spongepowered.api.command.CommandResult;
import org.spongepowered.api.command.CommandSource;
import org.spongepowered.api.command.args.CommandContext;
import org.spongepowered.api.command.spec.CommandExecutor;
import org.spongepowered.api.entity.living.player.Player;
import org.spongepowered.api.text.Text;

public class CmdJoin
implements CommandExecutor {
    private static final CmdJoin INSTANCE = new CmdJoin();

    private CmdJoin() {
    }

    public static CmdJoin getInstance() {
        return INSTANCE;
    }

    public CommandResult execute(CommandSource src, CommandContext args) throws CommandException {
        Player player;
        Optional playerArg = args.getOne((Text)Text.of((String)"player"));
        if (src instanceof Player) {
            if (playerArg.isPresent() && src != playerArg.get()) {
                src.sendMessage((Text)Text.of((String)"This must be executed using a command block."));
                return CommandResult.empty();
            }
            player = (Player)src;
        } else {
            if (!playerArg.isPresent()) {
                return CommandResult.empty();
            }
            player = (Player)playerArg.get();
        }
        Gamer gamer = GamersManager.getGamer(player.getUniqueId()).get();
        Optional optMode = args.getOne("mode");
        if (!optMode.isPresent()) {
            return CommandResult.empty();
        }
        if (GamersManager.isInGame(player)) {
            player.sendMessage((Text)Text.of((String)"You're already in a game. Use /ba quit to leave the current game session."));
            return CommandResult.empty();
        }
        Game game = GameManager.getInstance().getGame((String)optMode.get());
        if (game == null) {
            player.sendMessage((Text)Text.of((String)"There's no available arena at this time."));
            return CommandResult.empty();
        }
        game.add(gamer);
        return CommandResult.success();
    }
}

