/*
 * Decompiled with CFR 0.152.
 */
package io.github.mrdarcychen.commands;

import io.github.mrdarcychen.games.GamersManager;
import io.github.mrdarcychen.utils.KitManager;
import java.util.Optional;
import org.spongepowered.api.command.CommandException;
import org.spongepowered.api.command.CommandResult;
import org.spongepowered.api.command.CommandSource;
import org.spongepowered.api.command.args.CommandContext;
import org.spongepowered.api.command.spec.CommandExecutor;
import org.spongepowered.api.entity.living.player.Player;
import org.spongepowered.api.text.Text;

public class CmdKit
implements CommandExecutor {
    private static final CmdKit INSTANCE = new CmdKit();

    private CmdKit() {
    }

    public static CmdKit getInstance() {
        return INSTANCE;
    }

    public CommandResult execute(CommandSource src, CommandContext args) throws CommandException {
        Player player;
        Optional playerArg = args.getOne((Text)Text.of((String)"player"));
        if (src instanceof Player) {
            if (playerArg.isPresent() && src != playerArg.get()) {
                src.sendMessage((Text)Text.of((String)"This must be executed using a command block."));
                return CommandResult.empty();
            }
            player = (Player)src;
        } else {
            if (!playerArg.isPresent()) {
                return CommandResult.empty();
            }
            player = (Player)playerArg.get();
        }
        if (!this.inGame(player)) {
            player.sendMessage((Text)Text.of((String)"You must be in an active game session to get a kit."));
            return CommandResult.empty();
        }
        String id = (String)args.getOne((Text)Text.of((String)"id")).get();
        if (KitManager.getInstance().get(id) == null) {
            player.sendMessage((Text)Text.of((String)("Kit " + id + " does not exist.")));
            return CommandResult.empty();
        }
        KitManager.getInstance().get(id).equip(player);
        return CommandResult.success();
    }

    private boolean inGame(Player player) {
        return GamersManager.getGamer(player.getUniqueId()).get().getGame().isPresent();
    }
}

