/*
 * Decompiled with CFR 0.152.
 */
package io.github.mrdarcychen.commands;

import io.github.mrdarcychen.arenas.ArenaManager;
import io.github.mrdarcychen.utils.KitManager;
import org.spongepowered.api.command.CommandException;
import org.spongepowered.api.command.CommandResult;
import org.spongepowered.api.command.CommandSource;
import org.spongepowered.api.command.args.CommandContext;
import org.spongepowered.api.command.spec.CommandExecutor;
import org.spongepowered.api.text.Text;

public class CmdRemove
implements CommandExecutor {
    private static final CmdRemove instance = new CmdRemove();

    private CmdRemove() {
    }

    public static CmdRemove getInstance() {
        return instance;
    }

    public CommandResult execute(CommandSource src, CommandContext args) throws CommandException {
        String type = ((String)args.getOne("type").get()).toLowerCase();
        String id = ((String)args.getOne("id").get()).toLowerCase();
        switch (type) {
            case "arena": {
                try {
                    ArenaManager.getInstance().remove(id);
                    break;
                }
                catch (IllegalArgumentException e) {
                    src.sendMessage((Text)Text.of((String)e.getMessage()));
                    return CommandResult.empty();
                }
            }
            case "kit": {
                try {
                    KitManager.getInstance().remove(id);
                    break;
                }
                catch (IllegalArgumentException e) {
                    src.sendMessage((Text)Text.of((String)e.getMessage()));
                    return CommandResult.empty();
                }
            }
            default: {
                src.sendMessage((Text)Text.of((String)"<type> must be either arena or kit."));
                return CommandResult.empty();
            }
        }
        src.sendMessage((Text)Text.of((String)(id + " has been removed.")));
        return CommandResult.success();
    }
}

