/*
 * Decompiled with CFR 0.152.
 */
package io.github.mrdarcychen.games;

import io.github.mrdarcychen.arenas.Arena;
import io.github.mrdarcychen.games.TeamMode;
import io.github.mrdarcychen.games.states.EnteringState;
import io.github.mrdarcychen.games.states.MatchState;
import io.github.mrdarcychen.utils.DamageData;
import io.github.mrdarcychen.utils.Gamer;
import io.github.mrdarcychen.utils.PlayerSnapshot;
import java.util.ArrayList;
import java.util.List;
import org.spongepowered.api.entity.living.player.Player;
import org.spongepowered.api.event.entity.DamageEntityEvent;

public class Game {
    protected Arena arena;
    private MatchState state;
    private List<PlayerSnapshot> snapshots;
    private TeamMode teamMode;

    public Game(TeamMode teamMode, Arena arena) {
        this.arena = arena;
        this.teamMode = teamMode;
        arena.setBusy(true);
        this.snapshots = new ArrayList<PlayerSnapshot>();
        this.state = new EnteringState(this, new ArrayList<Gamer>());
    }

    public void add(Gamer gamer) {
        this.state.recruit(gamer);
    }

    public void remove(Gamer gamer) {
        this.state.dismiss(gamer);
    }

    public void analyze(DamageEntityEvent event, DamageData damageData) {
        this.state.analyze(event, damageData);
    }

    public void addSnapshot(PlayerSnapshot snapshot) {
        this.snapshots.add(snapshot);
    }

    public void restoreSnapshotOf(Player player) {
        this.snapshots.stream().filter(it -> it.getPlayer().equals(player)).findAny().ifPresent(PlayerSnapshot::restore);
    }

    public void restoreSnapshots() {
        this.snapshots.forEach(PlayerSnapshot::restore);
    }

    public boolean canJoin() {
        return this.state instanceof EnteringState;
    }

    public Arena getArena() {
        return this.arena;
    }

    public void setMatchState(MatchState state) {
        this.state = state;
    }

    public TeamMode getTeamMode() {
        return this.teamMode;
    }
}

