/*
 * Decompiled with CFR 0.152.
 */
package io.github.mrdarcychen.games;

import io.github.mrdarcychen.arenas.Arena;
import io.github.mrdarcychen.arenas.ArenaManager;
import io.github.mrdarcychen.games.Game;
import io.github.mrdarcychen.games.TeamMode;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.function.Predicate;

public class GameManager {
    private static final GameManager INSTANCE = new GameManager();
    private List<Game> games = new ArrayList<Game>();

    private GameManager() {
    }

    public static GameManager getInstance() {
        return INSTANCE;
    }

    public Game getGame(String str) {
        String mode = str.toLowerCase();
        Predicate<Game> criteria = it -> it.canJoin() && it.getTeamMode().toString().equals(mode);
        Optional<Game> optGame = this.games.stream().filter(criteria).findAny();
        if (optGame.isPresent()) {
            return optGame.get();
        }
        Optional<Arena> optArena = ArenaManager.getInstance().findArena(mode);
        if (optArena.isPresent()) {
            Arena arena = optArena.get();
            int teamSize = 1;
            int teamCount = 2;
            if ("2v2".equals(mode)) {
                teamSize = 2;
            }
            if ("ffa".equals(mode)) {
                teamCount = (int)arena.getStartPoints().count();
            }
            TeamMode teamMode = new TeamMode(teamSize, teamCount);
            Game game = new Game(teamMode, optArena.get());
            this.games.add(game);
            return game;
        }
        return null;
    }

    public void remove(Game game) {
        this.games.remove(game);
    }
}

