/*
 * Decompiled with CFR 0.152.
 */
package io.github.mrdarcychen.games;

import io.github.mrdarcychen.utils.Gamer;
import java.util.HashSet;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import org.spongepowered.api.entity.living.player.Player;

public class GamersManager {
    private static Set<Gamer> gamers = new HashSet<Gamer>();

    public static void register(UUID uniqueId) {
        gamers.add(new Gamer(uniqueId));
    }

    public static Optional<Gamer> getGamer(UUID uniqueId) {
        for (Gamer gamer : gamers) {
            if (!gamer.getUniqueId().equals(uniqueId)) continue;
            return Optional.of(gamer);
        }
        return Optional.empty();
    }

    public static boolean isInGame(Player player) {
        Optional<Gamer> optGamer = GamersManager.getGamer(player.getUniqueId());
        return optGamer.map(gamer -> gamer.getGame().isPresent()).orElse(false);
    }
}

