/*
 * Decompiled with CFR 0.152.
 */
package io.github.mrdarcychen.games;

import io.github.mrdarcychen.arenas.SpawnPoint;
import io.github.mrdarcychen.utils.Gamer;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.spongepowered.api.text.Text;
import org.spongepowered.api.text.title.Title;

public class Team {
    private Map<Gamer, Boolean> gamers;
    private SpawnPoint startPoint;

    public Team(SpawnPoint startPoint) {
        this.startPoint = startPoint;
        this.gamers = new HashMap<Gamer, Boolean>();
    }

    public void add(Gamer gamer) {
        this.gamers.put(gamer, false);
    }

    public void eliminate(Gamer gamer) {
        this.gamers.replace(gamer, true);
    }

    public void sendAllToSpawn() {
        this.gamers.keySet().forEach(it -> it.getPlayer().setTransform(this.startPoint.getTransform()));
    }

    public boolean hasGamerLeft() {
        return this.gamers.values().stream().anyMatch(it -> it == false);
    }

    public void broadcast(Text text) {
        this.gamers.keySet().forEach(it -> it.getPlayer().sendMessage(text));
    }

    public void broadcast(Title title) {
        this.gamers.keySet().forEach(it -> it.getPlayer().sendTitle(title));
    }

    public boolean isEliminated(Gamer gamer) {
        return this.gamers.getOrDefault(gamer, false);
    }

    public boolean contains(Gamer gamer) {
        return this.gamers.containsKey(gamer);
    }

    public Set<Gamer> getGamers() {
        return this.gamers.keySet();
    }

    public String toString() {
        String str = "";
        Iterator<Gamer> gamersItr = this.gamers.keySet().iterator();
        while (gamersItr.hasNext()) {
            str = str + gamersItr.next().getName();
            if (!gamersItr.hasNext()) continue;
            str = str + ", ";
        }
        return str;
    }
}

