/*
 * Decompiled with CFR 0.152.
 */
package io.github.mrdarcychen.games.states;

import io.github.mrdarcychen.games.Game;
import io.github.mrdarcychen.games.states.LeavingState;
import io.github.mrdarcychen.games.states.MatchState;
import io.github.mrdarcychen.games.states.StartingState;
import io.github.mrdarcychen.managers.ConfigManager;
import io.github.mrdarcychen.utils.DamageData;
import io.github.mrdarcychen.utils.Gamer;
import java.util.List;
import org.spongepowered.api.event.entity.DamageEntityEvent;
import org.spongepowered.api.text.Text;

public class EnteringState
extends MatchState {
    public EnteringState(Game game, List<Gamer> gamers) {
        super(game, gamers);
    }

    @Override
    public void recruit(Gamer gamer) {
        if (this.gamers.size() == this.teamMode.getTotalCapacity()) {
            gamer.getPlayer().sendMessage((Text)Text.of((String)"Unable to join the game at this time."));
            return;
        }
        this.gamers.add(gamer);
        super.recruit(gamer);
        this.broadcast((Text)Text.of((String)(gamer.getName() + " joined the game. (" + this.gamers.size() + "/" + this.teamMode.getTotalCapacity() + ")")));
        if (this.gamers.size() == this.teamMode.getTotalCapacity()) {
            this.game.setMatchState(new StartingState(this.game, this.gamers, ConfigManager.getInstance().getLobbyCountdown()));
        }
    }

    @Override
    public void dismiss(Gamer gamer) {
        super.dismiss(gamer);
        this.gamers.remove(gamer);
        this.broadcast((Text)Text.of((String)(gamer.getName() + " left the game.(" + this.gamers.size() + "/" + this.teamMode.getTotalCapacity() + ")")));
        if (this.gamers.isEmpty()) {
            this.game.setMatchState(new LeavingState(this.game, this.gamers));
        }
    }

    @Override
    public void analyze(DamageEntityEvent event, DamageData damageData) {
        super.analyze(event, damageData);
    }
}

