/*
 * Decompiled with CFR 0.152.
 */
package io.github.mrdarcychen.games.states;

import io.github.mrdarcychen.arenas.Arena;
import io.github.mrdarcychen.arenas.SpawnPoint;
import io.github.mrdarcychen.games.Game;
import io.github.mrdarcychen.games.TeamMode;
import io.github.mrdarcychen.utils.DamageData;
import io.github.mrdarcychen.utils.Gamer;
import java.util.List;
import org.spongepowered.api.data.key.Keys;
import org.spongepowered.api.entity.living.player.Player;
import org.spongepowered.api.entity.living.player.gamemode.GameModes;
import org.spongepowered.api.event.entity.DamageEntityEvent;
import org.spongepowered.api.text.LiteralText;
import org.spongepowered.api.text.Text;
import org.spongepowered.api.text.format.TextColors;
import org.spongepowered.api.text.title.Title;

public abstract class MatchState {
    protected final Game game;
    protected List<Gamer> gamers;
    protected TeamMode teamMode;

    public MatchState(Game game, List<Gamer> gamers) {
        this.game = game;
        this.teamMode = game.getTeamMode();
        this.gamers = gamers;
    }

    public void recruit(Gamer gamer) {
        this.game.addSnapshot(gamer.takeSnapshot());
        gamer.setGame(this.game);
        Player player = gamer.getPlayer();
        player.getInventory().clear();
        player.sendMessage((Text)Text.of((String)("Sending you to " + this.game.getArena().getName() + " ...")));
        player.offer(Keys.GAME_MODE, (Object)GameModes.SURVIVAL);
        Arena arena = this.game.getArena();
        SpawnPoint spawnPoint = arena.getLobbySpawn();
        player.setTransform(spawnPoint.getTransform());
        player.offer(Keys.HEALTH, player.health().getMaxValue());
        gamer.spectate(false);
    }

    public void dismiss(Gamer gamer) {
        this.game.restoreSnapshotOf(gamer.getPlayer());
        gamer.setGame(null);
        gamer.spectate(false);
    }

    public void eliminate(Gamer gamer, Text cause) {
        this.broadcast(cause);
        gamer.spectate(true);
        Player player = gamer.getPlayer();
        player.setTransform(this.game.getArena().getSpectatorSpawn().getTransform());
        LiteralText deathText = Text.builder((String)"YOU DIED!").color(TextColors.RED).build();
        Title deathTitle = Title.builder().title((Text)deathText).fadeOut(Integer.valueOf(2)).stay(Integer.valueOf(16)).build();
        gamer.getPlayer().sendTitle(deathTitle);
    }

    public void analyze(DamageEntityEvent event, DamageData damageData) {
        if (damageData.getDamageType().getName().equalsIgnoreCase("void")) {
            damageData.getVictim().getPlayer().setTransform(this.game.getArena().getLobbySpawn().getTransform());
        }
        event.setCancelled(true);
    }

    public void broadcast(Text msg) {
        this.gamers.forEach(it -> it.getPlayer().sendMessage(msg));
    }
}

