/*
 * Decompiled with CFR 0.152.
 */
package io.github.mrdarcychen.games.states;

import io.github.mrdarcychen.games.Game;
import io.github.mrdarcychen.games.Team;
import io.github.mrdarcychen.games.states.MatchState;
import io.github.mrdarcychen.games.states.StoppingState;
import io.github.mrdarcychen.utils.DamageData;
import io.github.mrdarcychen.utils.Gamer;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.spongepowered.api.effect.particle.ParticleEffect;
import org.spongepowered.api.effect.particle.ParticleTypes;
import org.spongepowered.api.effect.sound.SoundTypes;
import org.spongepowered.api.entity.living.player.Player;
import org.spongepowered.api.event.entity.DamageEntityEvent;
import org.spongepowered.api.text.Text;

public class PlayingState
extends MatchState {
    private List<Team> teams;

    public PlayingState(Game game, List<Gamer> gamers, List<Team> teams) {
        super(game, gamers);
        this.teams = teams;
        teams.forEach(Team::sendAllToSpawn);
    }

    @Override
    public void dismiss(Gamer gamer) {
        this.gamers.remove(gamer);
        this.broadcast((Text)Text.of((String)(gamer.getName() + " left the game.(" + this.gamers.size() + "/" + this.teamMode.getTotalCapacity() + ")")));
        this.eliminate(gamer, (Text)Text.of((String)(gamer.getPlayer().getName() + " has left the game.")));
        super.dismiss(gamer);
    }

    @Override
    public void eliminate(Gamer gamer, Text cause) {
        super.eliminate(gamer, cause);
        this.teams.forEach(it -> it.eliminate(gamer));
        List teamsAlive = this.teams.stream().filter(Team::hasGamerLeft).collect(Collectors.toList());
        if (teamsAlive.size() == 1) {
            Team winner = (Team)teamsAlive.get(0);
            List<Team> losers = this.teams.stream().filter(it -> it != winner).collect(Collectors.toList());
            this.game.setMatchState(new StoppingState(this.game, this.gamers, winner, losers));
        }
    }

    @Override
    public void analyze(DamageEntityEvent event, DamageData damageData) {
        Gamer victim = damageData.getVictim();
        if (damageData.getDamageType().getName().equalsIgnoreCase("void")) {
            event.setCancelled(true);
            this.showDeathEffect(damageData.getVictim());
            this.eliminate(victim, (Text)Text.of((String)damageData.getDeathMessage()));
            return;
        }
        if (damageData.getAttacker().isPresent()) {
            Optional<Game> optGame;
            Gamer attacker = damageData.getAttacker().get();
            if (this.areTeammates(victim, attacker)) {
                attacker.getPlayer().playSound(SoundTypes.ITEM_SHIELD_BLOCK, attacker.getPlayer().getLocation().getPosition(), 50.0);
                event.setCancelled(true);
            }
            if (!(optGame = attacker.getGame()).isPresent() || !optGame.get().equals(this.game)) {
                event.setCancelled(true);
            }
            if (this.teams.stream().anyMatch(team -> team.isEliminated(attacker))) {
                event.setCancelled(true);
            }
        }
        if (event.willCauseDeath()) {
            event.setCancelled(true);
            this.showDeathEffect(victim);
            damageData.getAttacker().ifPresent(it -> it.getPlayer().playSound(SoundTypes.ENTITY_BAT_DEATH, it.getPlayer().getLocation().getPosition(), 100.0));
            this.eliminate(victim, (Text)Text.of((String)damageData.getDeathMessage()));
        }
    }

    private void showDeathEffect(Gamer gamer) {
        ParticleEffect effect = ParticleEffect.builder().type(ParticleTypes.FIREWORKS_SPARK).quantity(200).build();
        Player player = gamer.getPlayer();
        player.playSound(SoundTypes.ENTITY_BAT_DEATH, player.getLocation().getPosition(), 100.0);
        player.spawnParticles(effect, player.getLocation().getPosition());
    }

    private boolean areTeammates(Gamer a, Gamer b) {
        for (Team team : this.teams) {
            if (!team.contains(a) || !team.contains(b)) continue;
            return true;
        }
        return false;
    }
}

