/*
 * Decompiled with CFR 0.152.
 */
package io.github.mrdarcychen.games.states;

import io.github.mrdarcychen.arenas.SpawnPoint;
import io.github.mrdarcychen.games.Game;
import io.github.mrdarcychen.games.Team;
import io.github.mrdarcychen.games.Timer;
import io.github.mrdarcychen.games.states.EnteringState;
import io.github.mrdarcychen.games.states.MatchState;
import io.github.mrdarcychen.games.states.PlayingState;
import io.github.mrdarcychen.utils.Gamer;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.spongepowered.api.effect.sound.SoundTypes;
import org.spongepowered.api.entity.living.player.Player;
import org.spongepowered.api.text.Text;
import org.spongepowered.api.text.title.Title;

public class StartingState
extends MatchState {
    private Timer timer;

    public StartingState(Game game, List<Gamer> gamers, int countdown) {
        super(game, gamers);
        this.timer = new Timer(countdown, tMinus -> {
            if (tMinus == 0) {
                game.setMatchState(new PlayingState(game, gamers, this.partition()));
                return;
            }
            Title title = Title.builder().title(Text.of((Object[])new Object[]{tMinus})).fadeIn(Integer.valueOf(2)).fadeOut(Integer.valueOf(2)).stay(Integer.valueOf(16)).build();
            for (Gamer gamer : gamers) {
                Player player = gamer.getPlayer();
                player.sendTitle(title);
                player.playSound(SoundTypes.BLOCK_NOTE_HAT, player.getLocation().getPosition(), 100.0);
            }
        });
    }

    @Override
    public void dismiss(Gamer gamer) {
        super.dismiss(gamer);
        this.gamers.remove(gamer);
        this.broadcast((Text)Text.of((String)(gamer.getName() + " left the game.(" + this.gamers.size() + "/" + this.teamMode.getTotalCapacity() + ")")));
        if (this.gamers.size() <= this.teamMode.getTotalCapacity()) {
            this.timer.cancel();
            this.broadcast((Text)Text.of((String)"Waiting for more players to join ..."));
            this.game.setMatchState(new EnteringState(this.game, this.gamers));
        }
    }

    private List<Team> partition() {
        ArrayList<Team> teams = new ArrayList<Team>();
        this.game.getArena().getStartPoints().limit(this.teamMode.getTeamCount()).forEach(point -> teams.add(new Team((SpawnPoint)point)));
        Iterator gamersItr = this.gamers.iterator();
        int gamersLeft = this.gamers.size();
        while (gamersItr.hasNext()) {
            int teamNum = gamersLeft % teams.size();
            ((Team)teams.get(teamNum)).add((Gamer)gamersItr.next());
            --gamersLeft;
        }
        return teams;
    }
}

