/*
 * Decompiled with CFR 0.152.
 */
package io.github.mrdarcychen.games.states;

import io.github.mrdarcychen.games.Game;
import io.github.mrdarcychen.games.Team;
import io.github.mrdarcychen.games.Timer;
import io.github.mrdarcychen.games.states.LeavingState;
import io.github.mrdarcychen.games.states.MatchState;
import io.github.mrdarcychen.utils.Gamer;
import java.util.List;
import org.spongepowered.api.effect.sound.SoundTypes;
import org.spongepowered.api.text.Text;
import org.spongepowered.api.text.format.TextColors;
import org.spongepowered.api.text.format.TextStyle;
import org.spongepowered.api.text.format.TextStyles;
import org.spongepowered.api.text.title.Title;

public class StoppingState
extends MatchState {
    public StoppingState(Game game, List<Gamer> gamers, Team winner, List<Team> losers) {
        super(game, gamers);
        Title victory = Title.builder().title((Text)Text.builder((String)"VICTORY!").color(TextColors.GOLD).style(new TextStyle[]{TextStyles.BOLD}).build()).subtitle((Text)Text.of((String)(winner + " won the game."))).fadeIn(Integer.valueOf(1)).stay(Integer.valueOf(60)).fadeOut(Integer.valueOf(2)).build();
        Title gameOver = Title.builder().title((Text)Text.builder((String)"GAME OVER!").color(TextColors.RED).style(new TextStyle[]{TextStyles.BOLD}).build()).subtitle((Text)Text.of((String)(winner + " won the game."))).fadeIn(Integer.valueOf(1)).stay(Integer.valueOf(60)).fadeOut(Integer.valueOf(2)).build();
        winner.broadcast(victory);
        winner.getGamers().stream().map(Gamer::getPlayer).forEach(it -> it.playSound(SoundTypes.ENTITY_PLAYER_LEVELUP, it.getLocation().getPosition(), 100.0));
        losers.forEach(it -> {
            it.broadcast(gameOver);
            it.getGamers().forEach(gamer -> gamer.getPlayer().playSound(SoundTypes.BLOCK_GLASS_BREAK, gamer.getPlayer().getHeadRotation(), 100.0));
        });
        new Timer(5, tMinus -> {
            if (tMinus == 0) {
                game.setMatchState(new LeavingState(game, gamers));
            }
        });
    }
}

