/*
 * Decompiled with CFR 0.152.
 */
package io.github.mrdarcychen.listeners;

import io.github.mrdarcychen.BlockyArena;
import io.github.mrdarcychen.games.GamersManager;
import io.github.mrdarcychen.utils.Gamer;
import java.util.UUID;
import org.spongepowered.api.entity.living.player.Player;
import org.spongepowered.api.entity.living.player.User;
import org.spongepowered.api.event.Listener;
import org.spongepowered.api.event.network.ClientConnectionEvent;

public class ClientConnectionEventListener {
    @Listener
    public void onGamerLogin(ClientConnectionEvent.Login event) {
        User user = event.getTargetUser();
        UUID uniqueId = user.getUniqueId();
        if (!GamersManager.getGamer(uniqueId).isPresent()) {
            GamersManager.register(uniqueId);
        }
        Gamer gamer = GamersManager.getGamer(uniqueId).get();
        gamer.setOnline(true);
        gamer.setName(user.getName());
        gamer.setPlayer((Player)user.getPlayer().get());
        BlockyArena.getInstance().getLogger().debug("A new player logged in !");
    }

    @Listener
    public void onGamerLogout(ClientConnectionEvent.Disconnect event) {
        Player player = event.getTargetEntity();
        Gamer gamer = GamersManager.getGamer(player.getUniqueId()).get();
        gamer.setOnline(false);
        gamer.getGame().ifPresent(game -> game.remove(gamer));
    }
}

