/*
 * Decompiled with CFR 0.152.
 */
package io.github.mrdarcychen.managers;

import com.google.inject.Inject;
import io.github.mrdarcychen.BlockyArena;
import java.io.IOException;
import ninja.leaping.configurate.ConfigurationNode;
import ninja.leaping.configurate.ConfigurationOptions;
import ninja.leaping.configurate.commented.CommentedConfigurationNode;
import ninja.leaping.configurate.hocon.HoconConfigurationLoader;
import ninja.leaping.configurate.loader.ConfigurationLoader;
import org.spongepowered.api.config.DefaultConfig;

public class ConfigManager {
    private static final ConfigManager INSTANCE = new ConfigManager();
    private ConfigurationNode rootNode;
    @Inject
    @DefaultConfig(sharedRoot=true)
    private ConfigurationLoader<CommentedConfigurationNode> loader;

    private ConfigManager() {
    }

    public static ConfigManager getInstance() {
        return INSTANCE;
    }

    public void load() {
        this.loader = ((HoconConfigurationLoader.Builder)HoconConfigurationLoader.builder().setPath(BlockyArena.getInstance().getDefaultConfig())).build();
        if (!BlockyArena.getInstance().getDefaultConfig().toFile().exists()) {
            BlockyArena.getInstance().getLogger().error("Creating a default config for BlockyArena.");
            this.rootNode = this.loader.createEmptyNode(ConfigurationOptions.defaults());
            this.rootNode.getNode(new Object[]{"timers", "lobby", "cooldownSec"}).setValue((Object)15);
            try {
                this.loader.save(this.rootNode);
            }
            catch (IOException iOException) {}
        } else {
            try {
                this.rootNode = this.loader.load();
                this.loader.save(this.rootNode);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    public void reloadConfiguration() {
        try {
            this.rootNode = this.loader.load();
            this.loader.save(this.rootNode);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        BlockyArena.getInstance().getLogger().info("Configuration reloaded for BlockyArena!");
    }

    public ConfigurationNode getConfNode(Object ... path) {
        return this.rootNode.getNode(path);
    }

    public int getLobbyCountdown() {
        return this.rootNode.getNode(new Object[]{"timers", "lobby", "cooldownSec"}).getInt();
    }
}

