/*
 * Decompiled with CFR 0.152.
 */
package io.github.mrdarcychen.utils;

import io.github.mrdarcychen.games.GamersManager;
import io.github.mrdarcychen.utils.Gamer;
import java.util.Optional;
import org.spongepowered.api.entity.Entity;
import org.spongepowered.api.entity.living.player.Player;
import org.spongepowered.api.event.cause.Cause;
import org.spongepowered.api.event.cause.entity.damage.DamageType;
import org.spongepowered.api.event.cause.entity.damage.source.BlockDamageSource;
import org.spongepowered.api.event.cause.entity.damage.source.DamageSource;
import org.spongepowered.api.event.cause.entity.damage.source.EntityDamageSource;
import org.spongepowered.api.event.cause.entity.damage.source.IndirectEntityDamageSource;

public class DamageData {
    private final Gamer victim;
    private Gamer attacker;
    private DamageType damageType;

    public DamageData(Gamer victim, Cause cause) {
        this.victim = victim;
        Optional optDamageSourcecause = cause.first(DamageSource.class);
        if (optDamageSourcecause.isPresent()) {
            DamageSource damageSource = (DamageSource)optDamageSourcecause.get();
            this.damageType = damageSource.getType();
            if (damageSource instanceof IndirectEntityDamageSource) {
                IndirectEntityDamageSource indirectEntityDamageSource = (IndirectEntityDamageSource)damageSource;
                Entity indirectSource = indirectEntityDamageSource.getIndirectSource();
                if (indirectSource instanceof Player) {
                    Player player = (Player)indirectSource;
                    this.attacker = GamersManager.getGamer(player.getUniqueId()).get();
                }
            } else if (damageSource instanceof EntityDamageSource) {
                EntityDamageSource entityDamageSource = (EntityDamageSource)damageSource;
                Entity directSource = entityDamageSource.getSource();
                if (directSource instanceof Player) {
                    Player player = (Player)directSource;
                    this.attacker = GamersManager.getGamer(player.getUniqueId()).get();
                }
            } else if (damageSource instanceof BlockDamageSource) {
                // empty if block
            }
        }
    }

    public String getDeathMessage() {
        if (this.damageType.getName().equalsIgnoreCase("attack") && this.attacker != null) {
            return this.victim.getName() + " was killed by " + this.attacker.getName() + ".";
        }
        if (this.damageType.getName().equalsIgnoreCase("fall")) {
            return this.victim.getName() + " fell from a high place.";
        }
        if (this.damageType.getName().equalsIgnoreCase("fire")) {
            return this.victim.getName() + " was burned to death.";
        }
        if (this.damageType.getName().equalsIgnoreCase("magic") && this.attacker != null) {
            return this.victim.getName() + " was killed by " + this.attacker.getName() + "'s magic.";
        }
        if (this.damageType.getName().equalsIgnoreCase("void")) {
            return this.victim.getName() + " fell into the void.";
        }
        return this.victim.getName() + " died.";
    }

    public Optional<Gamer> getAttacker() {
        return Optional.ofNullable(this.attacker);
    }

    public Gamer getVictim() {
        return this.victim;
    }

    public DamageType getDamageType() {
        return this.damageType;
    }
}

