/*
 * Decompiled with CFR 0.152.
 */
package io.github.mrdarcychen.utils;

import io.github.mrdarcychen.games.Game;
import io.github.mrdarcychen.utils.PlayerSnapshot;
import java.util.Optional;
import java.util.UUID;
import org.spongepowered.api.data.key.Keys;
import org.spongepowered.api.entity.living.player.Player;

public class Gamer {
    private final UUID uniqueId;
    private boolean isOnline;
    private String name;
    private Player player;
    private Game game;

    public Gamer(UUID uniqueId) {
        this.uniqueId = uniqueId;
    }

    public Optional<Game> getGame() {
        return Optional.ofNullable(this.game);
    }

    public PlayerSnapshot takeSnapshot() {
        return new PlayerSnapshot(this.player);
    }

    public void spectate(boolean i) {
        this.player.offer(Keys.HEALTH, this.player.health().getMaxValue());
        this.player.offer(Keys.FOOD_LEVEL, this.player.foodLevel().getMaxValue());
        this.player.offer(Keys.VANISH, (Object)i);
        this.player.offer(Keys.VANISH_IGNORES_COLLISION, (Object)i);
        this.player.offer(Keys.CAN_FLY, (Object)i);
        this.player.offer(Keys.IS_FLYING, (Object)i);
        this.player.offer(Keys.INVULNERABLE, (Object)i);
    }

    public UUID getUniqueId() {
        return this.uniqueId;
    }

    public void setOnline(boolean isOnline) {
        this.isOnline = isOnline;
    }

    public boolean isOnline() {
        return this.isOnline;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public void setPlayer(Player player) {
        this.player = player;
    }

    public Player getPlayer() {
        return this.player;
    }

    public void setGame(Game game) {
        this.game = game;
    }
}

