/*
 * Decompiled with CFR 0.152.
 */
package io.github.mrdarcychen.utils;

import java.util.Map;
import java.util.Optional;
import java.util.TreeMap;
import org.spongepowered.api.entity.living.player.Player;
import org.spongepowered.api.item.inventory.ItemStack;
import org.spongepowered.api.item.inventory.Slot;
import org.spongepowered.api.item.inventory.entity.PlayerInventory;
import org.spongepowered.api.item.inventory.equipment.EquipmentType;
import org.spongepowered.api.item.inventory.equipment.EquipmentTypes;
import org.spongepowered.api.item.inventory.property.SlotIndex;

public class Kit {
    private String id;
    private Map<SlotIndex, ItemStack> main;
    private Optional<ItemStack> headwear;
    private Optional<ItemStack> chestplate;
    private Optional<ItemStack> leggings;
    private Optional<ItemStack> boots;
    private Optional<ItemStack> offHand;

    public Kit(Player player, String id) {
        this.id = id;
        this.main = new TreeMap<SlotIndex, ItemStack>();
        PlayerInventory inventory = (PlayerInventory)player.getInventory();
        Iterable mainSlots = inventory.getMain().slots();
        int index = 0;
        for (Slot slot : mainSlots) {
            if (slot.peek().isPresent()) {
                this.main.put(SlotIndex.of((Object)index), (ItemStack)slot.peek().get());
            }
            ++index;
        }
        this.headwear = ((Slot)inventory.getEquipment().getSlot((EquipmentType)EquipmentTypes.HEADWEAR).get()).peek();
        this.chestplate = ((Slot)inventory.getEquipment().getSlot((EquipmentType)EquipmentTypes.CHESTPLATE).get()).peek();
        this.leggings = ((Slot)inventory.getEquipment().getSlot((EquipmentType)EquipmentTypes.LEGGINGS).get()).peek();
        this.boots = ((Slot)inventory.getEquipment().getSlot((EquipmentType)EquipmentTypes.BOOTS).get()).peek();
        this.offHand = inventory.getOffhand().peek();
    }

    public Kit(String id, Map<SlotIndex, ItemStack> main, Optional<ItemStack> headwear, Optional<ItemStack> chestplate, Optional<ItemStack> leggings, Optional<ItemStack> boots, Optional<ItemStack> offHand) {
        this.id = id;
        this.main = main;
        this.headwear = headwear;
        this.chestplate = chestplate;
        this.leggings = leggings;
        this.boots = boots;
        this.offHand = offHand;
    }

    public void equip(Player player) {
        player.getInventory().clear();
        PlayerInventory inventory = (PlayerInventory)player.getInventory();
        for (SlotIndex slotIndex : this.main.keySet()) {
            inventory.getMain().set(slotIndex, this.main.get(slotIndex).copy());
        }
        this.headwear.ifPresent(itemStack -> player.setHelmet(itemStack.copy()));
        this.chestplate.ifPresent(itemStack -> player.setChestplate(itemStack.copy()));
        this.leggings.ifPresent(itemStack -> player.setLeggings(itemStack.copy()));
        this.boots.ifPresent(itemStack -> player.setBoots(itemStack.copy()));
        this.offHand.ifPresent(itemStack -> inventory.getOffhand().set(itemStack.copy()));
    }

    public String getId() {
        return this.id;
    }

    public Map<SlotIndex, ItemStack> getMain() {
        return this.main;
    }

    public Optional<ItemStack> getHeadwear() {
        return this.headwear;
    }

    public Optional<ItemStack> getChestplate() {
        return this.chestplate;
    }

    public Optional<ItemStack> getLeggings() {
        return this.leggings;
    }

    public Optional<ItemStack> getBoots() {
        return this.boots;
    }

    public Optional<ItemStack> getOffHand() {
        return this.offHand;
    }
}

