/*
 * Decompiled with CFR 0.152.
 */
package io.github.mrdarcychen.utils;

import com.google.common.reflect.TypeToken;
import io.github.mrdarcychen.BlockyArena;
import io.github.mrdarcychen.utils.Kit;
import java.io.File;
import java.io.IOException;
import java.nio.file.DirectoryStream;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.HashMap;
import java.util.Map;
import ninja.leaping.configurate.ConfigurationNode;
import ninja.leaping.configurate.hocon.HoconConfigurationLoader;
import ninja.leaping.configurate.objectmapping.ObjectMappingException;
import org.spongepowered.api.data.persistence.InvalidDataException;

public class KitManager {
    private static final KitManager INSTANCE = new KitManager();
    private Map<String, Kit> kits = new HashMap<String, Kit>();

    private KitManager() {
    }

    public static KitManager getInstance() {
        return INSTANCE;
    }

    public void loadKits() {
        try {
            DirectoryStream<Path> stream = Files.newDirectoryStream(BlockyArena.getInstance().getKitDir(), "*.conf");
            for (Path path : stream) {
                HoconConfigurationLoader loader = ((HoconConfigurationLoader.Builder)HoconConfigurationLoader.builder().setPath(path)).build();
                ConfigurationNode rootNode = loader.load();
                String id = rootNode.getNode(new Object[]{"id"}).getString();
                try {
                    Kit kit = (Kit)rootNode.getValue(TypeToken.of(Kit.class));
                    this.kits.put(kit.getId(), kit);
                }
                catch (InvalidDataException e) {
                    BlockyArena.getInstance().getLogger().warn("Kit " + id + " cannot be loaded because it contains unknown items.");
                }
                loader.save(rootNode);
            }
        }
        catch (ObjectMappingException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void add(Kit kit, String id) {
        this.kits.put(id, kit);
        BlockyArena.getInstance().getLogger().warn(id + " has been added to kit manager.");
        Path path = Paths.get(BlockyArena.getInstance().getKitDir().toString() + File.separator + id + ".conf", new String[0]);
        HoconConfigurationLoader loader = ((HoconConfigurationLoader.Builder)HoconConfigurationLoader.builder().setPath(path)).build();
        try {
            ConfigurationNode rootNode = loader.load();
            rootNode.setValue(TypeToken.of(Kit.class), (Object)kit);
            loader.save(rootNode);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        catch (ObjectMappingException e) {
            e.printStackTrace();
        }
    }

    public Kit get(String id) {
        return this.kits.get(id);
    }

    public void remove(String id) {
        this.kits.remove(id);
        Path path = Paths.get(BlockyArena.getInstance().getKitDir().toString() + File.separator + id + ".conf", new String[0]);
        try {
            Files.delete(path);
        }
        catch (IOException e) {
            throw new IllegalArgumentException(id + " does not exist.");
        }
    }
}

