/*
 * Decompiled with CFR 0.152.
 */
package io.github.mrdarcychen.utils;

import com.google.common.reflect.TypeToken;
import io.github.mrdarcychen.BlockyArena;
import io.github.mrdarcychen.utils.Kit;
import java.util.HashMap;
import java.util.Optional;
import ninja.leaping.configurate.ConfigurationNode;
import ninja.leaping.configurate.objectmapping.ObjectMappingException;
import ninja.leaping.configurate.objectmapping.serialize.TypeSerializer;
import org.spongepowered.api.item.inventory.ItemStack;
import org.spongepowered.api.item.inventory.property.SlotIndex;

public class KitSerializer
implements TypeSerializer<Kit> {
    public static BlockyArena plugin;

    public KitSerializer(BlockyArena plugin) {
        KitSerializer.plugin = plugin;
    }

    public Kit deserialize(TypeToken<?> type, ConfigurationNode value) throws ObjectMappingException {
        String id = value.getNode(new Object[]{"id"}).getString();
        Optional<Object> headwear = Optional.ofNullable(value.getNode(new Object[]{"headwear"}).getValue(TypeToken.of(ItemStack.class)));
        Optional<Object> chestplate = Optional.ofNullable(value.getNode(new Object[]{"chestplate"}).getValue(TypeToken.of(ItemStack.class)));
        Optional<Object> leggings = Optional.ofNullable(value.getNode(new Object[]{"leggings"}).getValue(TypeToken.of(ItemStack.class)));
        Optional<Object> boots = Optional.ofNullable(value.getNode(new Object[]{"boots"}).getValue(TypeToken.of(ItemStack.class)));
        Optional<Object> offHand = Optional.ofNullable(value.getNode(new Object[]{"offHand"}).getValue(TypeToken.of(ItemStack.class)));
        HashMap<SlotIndex, ItemStack> main = new HashMap<SlotIndex, ItemStack>();
        for (ConfigurationNode indexNode : value.getNode(new Object[]{"main"}).getChildrenMap().values()) {
            SlotIndex index = SlotIndex.of((Object)indexNode.getKey());
            ItemStack itemStack = (ItemStack)indexNode.getValue(TypeToken.of(ItemStack.class));
            main.put(index, itemStack);
        }
        return new Kit(id, main, headwear, chestplate, leggings, boots, offHand);
    }

    public void serialize(TypeToken<?> type, Kit obj, ConfigurationNode value) throws ObjectMappingException {
        value.getNode(new Object[]{"id"}).setValue((Object)obj.getId());
        value.getNode(new Object[]{"headwear"}).setValue(TypeToken.of(ItemStack.class), obj.getHeadwear().orElse(null));
        value.getNode(new Object[]{"chestplate"}).setValue(TypeToken.of(ItemStack.class), obj.getChestplate().orElse(null));
        value.getNode(new Object[]{"leggings"}).setValue(TypeToken.of(ItemStack.class), obj.getLeggings().orElse(null));
        value.getNode(new Object[]{"boots"}).setValue(TypeToken.of(ItemStack.class), obj.getBoots().orElse(null));
        value.getNode(new Object[]{"offHand"}).setValue(TypeToken.of(ItemStack.class), obj.getOffHand().orElse(null));
        for (SlotIndex index : obj.getMain().keySet()) {
            ConfigurationNode itemNode = value.getNode(new Object[]{"main"}).getNode(new Object[]{((Integer)index.getValue()).toString()});
            itemNode.setValue(TypeToken.of(ItemStack.class), (Object)obj.getMain().get(index));
        }
    }
}

