/*
 * Decompiled with CFR 0.152.
 */
package io.github.mrdarcychen.utils;

import io.github.mrdarcychen.utils.Kit;
import org.spongepowered.api.data.key.Keys;
import org.spongepowered.api.entity.Transform;
import org.spongepowered.api.entity.living.player.Player;
import org.spongepowered.api.entity.living.player.gamemode.GameMode;
import org.spongepowered.api.world.World;

public class PlayerSnapshot {
    private final Player player;
    private final Transform<World> transform;
    private final Kit kit;
    private final GameMode gameMode;
    private final double health;
    private final int food;

    public PlayerSnapshot(Player player) {
        this.player = player;
        this.transform = player.getTransform();
        this.kit = new Kit(player, null);
        this.gameMode = (GameMode)player.gameMode().get();
        this.health = (Double)player.health().get();
        this.food = (Integer)player.foodLevel().get();
    }

    public void restore() {
        this.player.setTransform(this.transform);
        this.kit.equip(this.player);
        this.player.offer(Keys.GAME_MODE, (Object)this.gameMode);
        this.player.offer(Keys.HEALTH, (Object)this.health);
        this.player.offer(Keys.FOOD_LEVEL, (Object)this.food);
    }

    public Player getPlayer() {
        return this.player;
    }
}

