/*
 * Decompiled with CFR 0.152.
 */
package de.dosmike.sponge.WebBooks;

import com.google.inject.Inject;
import de.dosmike.sponge.WebBooks.CommandRegistra;
import de.dosmike.sponge.WebBooks.Website;
import de.dosmike.sponge.WebBooks.WebsiteReadyConsumer;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.MalformedURLException;
import java.net.Proxy;
import java.util.HashSet;
import java.util.Set;
import java.util.UUID;
import ninja.leaping.configurate.ConfigurationNode;
import ninja.leaping.configurate.commented.CommentedConfigurationNode;
import ninja.leaping.configurate.loader.ConfigurationLoader;
import org.slf4j.Logger;
import org.spongepowered.api.Sponge;
import org.spongepowered.api.config.DefaultConfig;
import org.spongepowered.api.entity.living.player.Player;
import org.spongepowered.api.event.Listener;
import org.spongepowered.api.event.game.GameReloadEvent;
import org.spongepowered.api.event.game.state.GameStartedServerEvent;
import org.spongepowered.api.event.network.ClientConnectionEvent;
import org.spongepowered.api.plugin.Plugin;
import org.spongepowered.api.plugin.PluginContainer;
import org.spongepowered.api.text.Text;

@Plugin(id="webbook", name="WebBooks", version="1.1.1", authors={"DosMike"})
public class WebBooks {
    private static WebBooks instance;
    static String motd;
    @Inject
    private Logger logger;
    static Set<UUID> loading;
    @Inject
    @DefaultConfig(sharedRoot=true)
    private ConfigurationLoader<CommentedConfigurationNode> configManager;

    static {
        motd = null;
        loading = new HashSet<UUID>();
    }

    static WebBooks getInstance() {
        return instance;
    }

    static void l(String format, Object ... args) {
        WebBooks.instance.logger.info(String.format(format, args));
    }

    static void w(String format, Object ... args) {
        WebBooks.instance.logger.warn(String.format(format, args));
    }

    public boolean isWebsiteLoadingFor(Player player) {
        return loading.contains(player.getUniqueId());
    }

    @Listener
    public void onPlayerDisconnect(ClientConnectionEvent.Disconnect event) {
        loading.remove(event.getTargetEntity().getUniqueId());
    }

    @Listener
    public void onPlayerJoin(ClientConnectionEvent.Join event) {
        if (!motd.isEmpty()) {
            WebBooks.loadUrl(motd, event.getTargetEntity(), website -> {
                if (website.getResponseCode() == 200) {
                    website.displayBook(event.getTargetEntity());
                }
            });
        }
    }

    @Listener
    public void onServerStart(GameStartedServerEvent event) {
        instance = this;
        CommandRegistra.RegisterCommands();
        PluginContainer minecraft = (PluginContainer)Sponge.getPluginManager().getPlugin("minecraft").get();
        PluginContainer sponge = (PluginContainer)Sponge.getPluginManager().getPlugin("sponge").get();
        PluginContainer container = (PluginContainer)Sponge.getPluginManager().fromInstance((Object)this).get();
        Website.UserAgent = String.format("%s(%s/%s) %s/%s %s/%s(%s) %s", minecraft.getName(), Sponge.getPlatform().getExecutionType().toString(), Sponge.getPlatform().getType().toString(), minecraft.getVersion().orElse("?"), sponge.getName(), sponge.getVersion().orElse("?"), container.getName(), container.getId(), container.getVersion().orElse("?"));
        if (!Sponge.getConfigManager().getSharedConfig((Object)this).getConfigPath().toFile().exists()) {
            CommentedConfigurationNode root = (CommentedConfigurationNode)this.configManager.createEmptyNode();
            root.getNode(new Object[]{"Proxy"}).setComment("Here you can set a HTTP-Proxy for the Game-Server to use when connecting to the Web-Server. Note: The overall delay must not exceed 3 seconds!");
            root.getNode(new Object[]{"Proxy", "Host"}).setValue((Object)"");
            root.getNode(new Object[]{"Proxy", "Host"}).setComment("Leave this value empty to disable the proxy");
            root.getNode(new Object[]{"Proxy", "Port"}).setValue((Object)8080);
            root.getNode(new Object[]{"MOTD"}).setComment("Specify a URL here that will be displayed to every player that joins the server");
            try {
                this.configManager.save((ConfigurationNode)root);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        this.loadConfig();
    }

    @Listener
    public void onReload(GameReloadEvent event) {
        this.loadConfig();
    }

    public static void loadUrl(String url, Player player, WebsiteReadyConsumer callback) {
        if (loading.contains(player.getUniqueId())) {
            throw new IllegalStateException("This player is already loading a website, try again in a moment");
        }
        loading.add(player.getUniqueId());
        Sponge.getScheduler().createAsyncExecutor((Object)WebBooks.getInstance()).execute(() -> {
            try {
                try {
                    callback.onWebsiteReady(Website.fromUrl(url, player));
                }
                catch (MalformedURLException u) {
                    player.sendMessage((Text)Text.of((String)("Malformed URL: " + url)));
                    loading.remove(player.getUniqueId());
                }
                catch (Exception e) {
                    e.printStackTrace();
                    loading.remove(player.getUniqueId());
                }
            }
            finally {
                loading.remove(player.getUniqueId());
            }
        });
    }

    public static Website parseHtml(String html, String baseURL, Player player) {
        return Website.fromHtml(html, baseURL, player);
    }

    private void loadConfig() {
        try {
            ConfigurationNode s = this.configManager.load();
            String host = s.getNode(new Object[]{"Proxy", "Host"}).getString("");
            int port = s.getNode(new Object[]{"Proxy", "Port"}).getInt(8080);
            Website.proxy = host.isEmpty() ? null : new Proxy(Proxy.Type.HTTP, new InetSocketAddress(host, port));
            motd = s.getNode(new Object[]{"MOTD"}).getString("");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

