/*
 * Decompiled with CFR 0.152.
 */
package de.dosmike.sponge.WebBooks;

import java.io.IOException;
import java.net.MalformedURLException;
import java.net.Proxy;
import java.net.URL;
import java.time.Instant;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.jsoup.Connection;
import org.jsoup.Jsoup;
import org.jsoup.nodes.Document;
import org.jsoup.nodes.Element;
import org.jsoup.nodes.Node;
import org.jsoup.nodes.TextNode;
import org.spongepowered.api.Sponge;
import org.spongepowered.api.command.CommandSource;
import org.spongepowered.api.data.key.Keys;
import org.spongepowered.api.entity.living.player.Player;
import org.spongepowered.api.entity.living.player.gamemode.GameModes;
import org.spongepowered.api.item.ItemTypes;
import org.spongepowered.api.item.inventory.ItemStack;
import org.spongepowered.api.service.pagination.PaginationList;
import org.spongepowered.api.text.BookView;
import org.spongepowered.api.text.Text;
import org.spongepowered.api.text.action.ClickAction;
import org.spongepowered.api.text.action.HoverAction;
import org.spongepowered.api.text.action.TextActions;
import org.spongepowered.api.text.channel.MessageReceiver;
import org.spongepowered.api.text.format.TextColor;
import org.spongepowered.api.text.format.TextColors;
import org.spongepowered.api.text.format.TextFormat;
import org.spongepowered.api.text.format.TextStyle;
import org.spongepowered.api.text.format.TextStyles;
import org.spongepowered.api.world.World;

public class Website {
    static String UserAgent = "Minecraft-Server/WebBooks unknown";
    static Proxy proxy;
    static Map<String, Object> classNames;
    String url;
    int recode;
    Map<String, String> reheaders;
    List<Text> pages = new LinkedList<Text>();
    Text title;

    static {
        classNames = new HashMap<String, Object>();
        classNames.put("mc-0", TextColors.BLACK);
        classNames.put("mc-1", TextColors.DARK_BLUE);
        classNames.put("mc-2", TextColors.DARK_GREEN);
        classNames.put("mc-3", TextColors.DARK_AQUA);
        classNames.put("mc-4", TextColors.DARK_RED);
        classNames.put("mc-5", TextColors.DARK_PURPLE);
        classNames.put("mc-6", TextColors.GOLD);
        classNames.put("mc-7", TextColors.GRAY);
        classNames.put("mc-8", TextColors.DARK_GRAY);
        classNames.put("mc-9", TextColors.BLUE);
        classNames.put("mc-a", TextColors.GREEN);
        classNames.put("mc-b", TextColors.AQUA);
        classNames.put("mc-c", TextColors.RED);
        classNames.put("mc-d", TextColors.LIGHT_PURPLE);
        classNames.put("mc-e", TextColors.YELLOW);
        classNames.put("mc-f", TextColors.WHITE);
        classNames.put("mc-k", TextStyles.OBFUSCATED);
        classNames.put("mc-l", TextStyles.BOLD);
        classNames.put("mc-m", TextStyles.STRIKETHROUGH);
        classNames.put("mc-n", TextStyles.UNDERLINE);
        classNames.put("mc-o", TextStyles.ITALIC);
        classNames.put("mc-r", TextFormat.of((TextColor)TextColors.RESET, (TextStyle)TextStyles.RESET));
    }

    private static Text parseNodes(Node node) {
        block28: {
            if (node instanceof TextNode) {
                return Text.of((String)((TextNode)node).text().replace('\u00a0', ' '));
            }
            if (!(node instanceof Element)) break block28;
            Element elem = (Element)node;
            Text.Builder builder = Text.builder();
            LinkedList<Object> hoverText = new LinkedList<Object>();
            switch (elem.tagName().toLowerCase()) {
                case "b": {
                    builder.format(builder.getFormat().style((TextStyle)TextStyles.BOLD));
                    break;
                }
                case "u": {
                    builder.format(builder.getFormat().style((TextStyle)TextStyles.UNDERLINE));
                    break;
                }
                case "i": {
                    builder.format(builder.getFormat().style((TextStyle)TextStyles.ITALIC));
                    break;
                }
                case "s": {
                    builder.format(builder.getFormat().style((TextStyle)TextStyles.STRIKETHROUGH));
                    break;
                }
                case "a": {
                    builder.format(builder.getFormat().style((TextStyle)TextStyles.UNDERLINE).color(TextColors.DARK_AQUA));
                    ClickActionHolder action = Website.buildLinkAction(elem);
                    builder.onClick(action.getAction());
                    hoverText.add(action.getHoverText());
                    break;
                }
            }
            if (elem.hasAttr("class")) {
                elem.classNames().forEach(clzn -> {
                    if (classNames.containsKey(clzn)) {
                        Object format = classNames.get(clzn);
                        if (format instanceof TextStyle) {
                            builder.format(builder.getFormat().style((TextStyle)format));
                        } else if (format instanceof TextColor) {
                            builder.format(builder.getFormat().color((TextColor)format));
                        } else if (format instanceof TextFormat) {
                            builder.format((TextFormat)format);
                        } else {
                            throw new RuntimeException("Invalid format for web style-class " + clzn + ": " + format.getClass().getName());
                        }
                    }
                });
            }
            if (elem.hasAttr("title")) {
                hoverText.add(0, Text.of((String)elem.attr("title")));
            }
            if (!hoverText.isEmpty()) {
                Text.Builder smashed = Text.builder();
                boolean first = true;
                for (Text text : hoverText) {
                    if (first) {
                        first = false;
                    } else {
                        smashed.append(new Text[]{Text.NEW_LINE});
                    }
                    smashed.append(new Text[]{text});
                }
                builder.onHover((HoverAction)TextActions.showText((Text)smashed.build()));
            }
            node.childNodes().forEach(child -> {
                Text.Builder builder2 = builder.append(new Text[]{Website.parseNodes(child)});
            });
            builder.append(new Text[]{Text.of((String)"\u00a7r")});
            if (elem.isBlock()) {
                builder.append(new Text[]{Text.NEW_LINE});
            }
            if (elem.tagName().equalsIgnoreCase("p") || elem.tagName().equalsIgnoreCase("br")) {
                builder.append(new Text[]{Text.NEW_LINE});
            }
            return builder.build();
        }
        return Text.EMPTY;
    }

    private static ClickActionHolder buildLinkAction(Element elem) {
        String target = elem.attr("target");
        if (target.equalsIgnoreCase("_player")) {
            String perm;
            String cmd = elem.attr("href");
            if (cmd.charAt(0) != '/') {
                cmd = String.valueOf('/') + cmd;
            }
            if (!(perm = elem.attr("data-permission")).isEmpty()) {
                return new ClickActionHolder((ClickAction<?>)TextActions.executeCallback(t -> {
                    if (t.hasPermission(elem.attr("data-permission"))) {
                        Sponge.getCommandManager().process(t, elem.attr("href"));
                    } else {
                        t.sendMessage(Text.of((Object[])new Object[]{TextColors.RED, "You do not have permission to click that link!"}));
                    }
                }), Text.of((Object[])new Object[]{TextColors.GREEN, !perm.isEmpty() ? "\u00b6 " : "", "Run: ", TextColors.WHITE, elem.attr("href")}));
            }
            return new ClickActionHolder((ClickAction<?>)TextActions.runCommand((String)cmd), Text.of((Object[])new Object[]{TextColors.GREEN, "Run: ", TextColors.WHITE, elem.attr("href")}));
        }
        if (target.equalsIgnoreCase("_server")) {
            String perm = elem.attr("data-permission");
            return new ClickActionHolder((ClickAction<?>)TextActions.executeCallback(t -> {
                if (t.hasPermission(elem.attr("data-permission"))) {
                    Sponge.getCommandManager().process((CommandSource)Sponge.getServer().getConsole(), elem.attr("href"));
                } else {
                    t.sendMessage(Text.of((Object[])new Object[]{TextColors.RED, "You do not have permission to click that link!"}));
                }
            }), Text.of((Object[])new Object[]{TextColors.RED, !perm.isEmpty() ? "\u00b6 " : "", "Server: ", TextColors.WHITE, elem.attr("href")}));
        }
        if (target.equalsIgnoreCase("_blank")) {
            try {
                return new ClickActionHolder((ClickAction<?>)TextActions.openUrl((URL)new URL(elem.absUrl("href"))), Text.of((Object[])new Object[]{TextColors.AQUA, "Extern: ", TextColors.WHITE, elem.attr("href")}));
            }
            catch (Exception e) {
                return new ClickActionHolder((ClickAction<?>)TextActions.executeCallback(activator -> activator.sendMessage((Text)Text.of((String)("This link is broken: " + elem.absUrl("href"))))), Text.of((Object[])new Object[]{TextColors.GRAY, TextStyles.STRIKETHROUGH, "Broken Link"}));
            }
        }
        if (elem.attr("href").charAt(0) == '#') {
            String page = elem.attr("href").substring(1);
            try {
                int p = Integer.parseInt(page);
                return new ClickActionHolder((ClickAction<?>)TextActions.changePage((int)p), Text.of((Object[])new Object[]{TextColors.GRAY, "Goto page " + p}));
            }
            catch (Exception e) {
                return new ClickActionHolder((ClickAction<?>)TextActions.executeCallback(activator -> activator.sendMessage((Text)Text.of((String)("Unknown jump reference: " + elem.attr("href"))))), Text.of((Object[])new Object[]{TextColors.GRAY, TextStyles.STRIKETHROUGH, "Broken Link"}));
            }
        }
        return new ClickActionHolder((ClickAction<?>)TextActions.runCommand((String)("/webbook " + elem.absUrl("href"))), Text.of((Object[])new Object[]{TextColors.GRAY, "Url: ", TextColors.WHITE, elem.attr("href")}));
    }

    static Website fromUrl(String url, Player player) throws MalformedURLException, IOException {
        Connection con = Jsoup.connect(url).timeout(3000);
        con.header("User-Agent", UserAgent);
        if (proxy != null) {
            con.proxy(proxy);
        }
        con.data("Name", player.getName());
        con.data("UUID", player.getUniqueId().toString());
        con.data("World", String.valueOf(((World)player.getLocation().getExtent()).getName()) + "/" + ((World)player.getLocation().getExtent()).getUniqueId().toString());
        con.data("Location", String.valueOf(player.getLocation().getX()) + "/" + player.getLocation().getY() + "/" + player.getLocation().getZ());
        con.data("Connection", String.valueOf(player.getConnection().getAddress().getHostString()) + ":" + player.getConnection().getAddress().getPort() + "/" + player.getConnection().getLatency() + "ms");
        con.data("Joined", String.valueOf(((Instant)player.getJoinData().lastPlayed().get()).toEpochMilli()) + "/" + ((Instant)player.getJoinData().firstPlayed().get()).toEpochMilli());
        con.data("Status", player.get(Keys.HEALTH).orElse(-1.0) + "/" + player.get(Keys.FOOD_LEVEL).orElse(-1) + "/" + player.get(Keys.EXPERIENCE_LEVEL).orElse(-1) + "/" + player.get(Keys.GAME_MODE).orElse(GameModes.NOT_SET).toString());
        con.followRedirects(true);
        Document doc = con.post();
        return Website.parseDocument(doc, con.response().statusCode(), con.response().headers());
    }

    static Website fromHtml(String html, String baseUrl, Player player) {
        return Website.parseDocument(Jsoup.parse(html, baseUrl), 200, new HashMap<String, String>());
    }

    private static Website parseDocument(Document doc, int rc, Map<String, String> headers) {
        Website website = new Website();
        website.url = doc.baseUri();
        website.recode = rc;
        website.reheaders = headers;
        Element title = doc.getElementsByTag("title").first();
        website.title = title != null ? Text.of((String)title.text()) : Text.of((String)"Unnamed");
        doc.getElementsByTag("ul").forEach(list -> {
            if (list.classNames().contains("book")) {
                list.children().forEach(item -> website.pages.add(Website.parseNodes(item)));
            }
        });
        return website;
    }

    public String getUrl() {
        return this.url;
    }

    public int getResponseCode() {
        return this.recode;
    }

    public Map<String, String> getResponseHeaders() {
        return this.reheaders;
    }

    public Text getTitle() {
        return this.title;
    }

    public Collection<Text> getPages() {
        return this.pages;
    }

    public void displayBook(Player player) {
        player.sendBookView(BookView.builder().title(this.title).addPages(this.pages).build());
    }

    public void displayChat(MessageReceiver receiver) {
        PaginationList.builder().title(this.title).contents(this.pages).footer((Text)Text.of((String)(String.valueOf(this.recode) + " - " + this.url))).build().sendTo(receiver);
    }

    public ItemStack save() {
        ItemStack stack = ItemStack.builder().itemType(ItemTypes.WRITTEN_BOOK).quantity(1).build();
        stack.offer(Keys.BOOK_AUTHOR, (Object)Text.of((Object[])new Object[]{TextColors.DARK_AQUA, "Saved Website"}));
        stack.offer(Keys.BOOK_PAGES, this.pages);
        stack.offer(Keys.DISPLAY_NAME, (Object)this.title);
        return stack;
    }

    private static class ClickActionHolder {
        private ClickAction<?> action;
        private Text text;

        public ClickActionHolder(ClickAction<?> action, Text linkHover) {
            this.action = action;
            this.text = linkHover;
        }

        public ClickAction<?> getAction() {
            return this.action;
        }

        public Text getHoverText() {
            return this.text;
        }
    }
}

