/*
 * Decompiled with CFR 0.152.
 */
package net.kyori.text.adapter.spongeapi;

import java.util.Collections;
import net.kyori.text.Component;
import net.kyori.text.serializer.gson.GsonComponentSerializer;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.spongepowered.api.text.Text;
import org.spongepowered.api.text.channel.ChatTypeMessageReceiver;
import org.spongepowered.api.text.channel.MessageReceiver;
import org.spongepowered.api.text.chat.ChatType;
import org.spongepowered.api.text.serializer.TextSerializers;

public interface TextAdapter {
    public static void sendComponent(@NonNull MessageReceiver viewer, @NonNull Component component) {
        TextAdapter.sendComponent(Collections.singleton(viewer), component);
    }

    public static void sendComponent(@NonNull Iterable<? extends MessageReceiver> viewers, @NonNull Component component) {
        Text text = TextSerializers.JSON.deserialize(GsonComponentSerializer.INSTANCE.serialize(component));
        for (MessageReceiver messageReceiver : viewers) {
            messageReceiver.sendMessage(text);
        }
    }

    public static void sendComponent(@NonNull ChatTypeMessageReceiver viewer, @NonNull Component component, @NonNull ChatType type) {
        TextAdapter.sendComponent(Collections.singleton(viewer), component, type);
    }

    public static void sendComponent(@NonNull Iterable<? extends ChatTypeMessageReceiver> viewers, @NonNull Component component, @NonNull ChatType type) {
        Text text = TextSerializers.JSON.deserialize(GsonComponentSerializer.INSTANCE.serialize(component));
        for (ChatTypeMessageReceiver chatTypeMessageReceiver : viewers) {
            chatTypeMessageReceiver.sendMessage(type, text);
        }
    }
}

