/*
 * Decompiled with CFR 0.152.
 */
package com.zeitheron.solarflux.init;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonStreamParser;
import com.zeitheron.solarflux.api.SolarFluxAPI;
import com.zeitheron.solarflux.api.SolarInfo;
import com.zeitheron.solarflux.block.BlockBaseSolar;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.stream.Collectors;
import net.minecraft.block.Block;
import net.minecraft.crash.CrashReport;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.util.ReportedException;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.common.registry.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.IForgeRegistryEntry;

public class SolarsSF {
    public static final SolarInfo SOLAR_1 = new SolarInfo(1L, 8, 25000L).setRegistryName("solarflux", "1");
    public static final SolarInfo SOLAR_2 = new SolarInfo(8L, 64, 125000L).setRegistryName("solarflux", "2");
    public static final SolarInfo SOLAR_3 = new SolarInfo(32L, 256, 425000L).setRegistryName("solarflux", "3");
    public static final SolarInfo SOLAR_4 = new SolarInfo(128L, 1024, 2000000L).setRegistryName("solarflux", "4");
    public static final SolarInfo SOLAR_5 = new SolarInfo(512L, 4096, 8000000L).setRegistryName("solarflux", "5");
    public static final SolarInfo SOLAR_6 = new SolarInfo(2048L, 16384, 32000000L).setRegistryName("solarflux", "6");
    public static final SolarInfo SOLAR_7 = new SolarInfo(8192L, 64000, 64000000L).setRegistryName("solarflux", "7");
    public static final SolarInfo SOLAR_8 = new SolarInfo(32768L, 256000, 128000000L).setRegistryName("solarflux", "8");
    private static File cfgDir;

    public static File getCfgDir() {
        return cfgDir;
    }

    public static File getCustomCfgDir() {
        Throwable throwable;
        boolean write;
        File ccfg = new File(SolarsSF.getCfgDir(), "_custom");
        if (!ccfg.isDirectory()) {
            ccfg.mkdirs();
        }
        File rdm = new File(ccfg, "README.txt");
        String internalMarker = "~ README v1.1 ~";
        boolean bl = write = !rdm.isFile();
        if (!write) {
            try {
                throwable = null;
                try (BufferedReader br = new BufferedReader(new InputStreamReader(new FileInputStream(rdm)));){
                    if (!br.readLine().equals(internalMarker)) {
                        write = true;
                    }
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
            }
            catch (Throwable br) {
                // empty catch block
            }
        }
        try {
            throwable = null;
            try (FileOutputStream fos = new FileOutputStream(rdm);){
                fos.write((internalMarker + System.lineSeparator()).getBytes());
                fos.write("This directory enables pack developers to add custom solar panels, with custom textures. Read this guide to understand, how to do so...\n\n\nThe first this you want to do is create a folder with internal solar panel name (registry ID). In-game, you would be able to give it to yourself using /give @p solarflux:custom_solar_panel_{NAME}\nAfter you've created the folder, make a new file called \"panel.json\"\nThere, fill out the following template:\n\n{\n\t\"capacity\": 0,\n\t\"generation\": 0,\n\t\"transfer\": 0,\n\t\"thickness\": 6,\n\t\"connected_textures\": true,\n\t\"localizations\": {\n\t\t\"en_us\": \"NAME Solar Panel\"\n\t}\n}\n\nWhen you're done, save it to \"panel.json\"\nOh also, please fill out the numerical fields to be greater than zero, or you'll run into troubles.\nSmall tips for the JSON:\n- You can remove \"thickness\" if you want to use standard 6-pixel thickness.\n- You can remove \"connected_textures\" if you want the panels to connect anyway.\n- Any language is supported, but the fallback is always \"en_us\", so keep that in place!\n\n\nNext up: textures!\nIn your panel folder, you're going to need 3 texture files: \"top.png\", \"top_full.png\" and \"base.png\".\nLet's have a quick look through each file...\n- base.png - The base texture. It's applied to sides and bottom of the solar panel.\n- top.png - this is what you would expect, the top face of the solar panel. HOWEVER! This texture MUST have borders of the \"base.png\", because this texture is rendered in the inventory.\n- top_full.png - this is the same as \"top.png\", but without any borders.\nThese textures can be animated, if provided with the NAME.mcmeta files, and fill them as in default minecraft resource packs.\n\n\nIf you're lazy enough to read all of this, I made a tutorial video, explaining all of this in details:\nhttps://youtu.be/AhEaUzP4ozk\n\n\nSincerely, Zeitheron.\nhttps://www.curseforge.com/projects/246974".getBytes());
            }
            catch (Throwable throwable3) {
                throwable = throwable3;
                throw throwable3;
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return ccfg;
    }

    public static Ingredient getGeneratingSolars(long gen) {
        return Ingredient.func_193369_a((ItemStack[])SolarFluxAPI.SOLAR_PANELS.getValuesCollection().stream().filter(s -> s.maxGeneration == gen).map(SolarInfo::getBlock).map(ItemStack::new).collect(Collectors.toList()).toArray(new ItemStack[0]));
    }

    public static void preInit(File file) {
        File[] customPanels;
        String apath = file.getAbsolutePath();
        cfgDir = new File(apath.substring(0, apath.lastIndexOf(46)));
        if (!cfgDir.isDirectory()) {
            cfgDir.mkdirs();
        }
        IForgeRegistry blocks = ForgeRegistries.BLOCKS;
        IForgeRegistry items = ForgeRegistries.ITEMS;
        IForgeRegistry<SolarInfo> solars = SolarFluxAPI.SOLAR_PANELS;
        Arrays.stream(SolarsSF.class.getDeclaredFields()).filter(f -> SolarInfo.class.isAssignableFrom(f.getType())).forEach(f -> {
            try {
                SolarInfo si = (SolarInfo)f.get(null);
                solars.register((IForgeRegistryEntry)si);
                BlockBaseSolar block = si.getBlock();
                blocks.register((IForgeRegistryEntry)block);
                ItemBlock model = new ItemBlock((Block)block);
                model.setRegistryName(block.getRegistryName());
                items.register((IForgeRegistryEntry)model);
                SolarFluxAPI.renderRenderer.accept((Item)model);
            }
            catch (Throwable err) {
                err.printStackTrace();
            }
        });
        for (File cpdir : customPanels = SolarsSF.getCustomCfgDir().listFiles(f -> f.isDirectory())) {
            File inf = new File(cpdir, "panel.json");
            if (!inf.isFile()) continue;
            SolarInfo si = new SolarInfo(0L, 0, 0L);
            si.setRegistryName(new ResourceLocation("solarflux", cpdir.getName()));
            si.isCustom = true;
            try (FileReader reader = new FileReader(inf);){
                JsonStreamParser j = new JsonStreamParser((Reader)reader);
                JsonObject cfg = j.next().getAsJsonObject();
                JsonElement je = cfg.get("capacity");
                if (je == null || je.getAsLong() <= 0L) {
                    String err = (je == null ? "\"capacity\" FIELD IS NOT FOUND" : "\"capacity\" FIELD IS LESS THAN OR EQUAL TO ZERO") + " IN CUSTOM SOLAR PANEL: " + cpdir.getName();
                    throw new ReportedException(new CrashReport(err, (Throwable)new RuntimeException(err)));
                }
                si.maxCapacity = je.getAsLong();
                je = cfg.get("generation");
                if (je == null || je.getAsLong() <= 0L) {
                    String err = (je == null ? "\"generation\" FIELD IS NOT FOUND" : "\"generation\" FIELD IS LESS THAN OR EQUAL TO ZERO") + " IN CUSTOM SOLAR PANEL: " + cpdir.getName();
                    throw new ReportedException(new CrashReport(err, (Throwable)new RuntimeException(err)));
                }
                si.maxGeneration = je.getAsLong();
                je = cfg.get("transfer");
                if (je == null || je.getAsLong() <= 0L) {
                    String err = (je == null ? "\"transfer\" FIELD IS NOT FOUND" : "\"transfer\" FIELD IS LESS THAN OR EQUAL TO ZERO") + " IN CUSTOM SOLAR PANEL: " + cpdir.getName();
                    throw new ReportedException(new CrashReport(err, (Throwable)new RuntimeException(err)));
                }
                si.maxTransfer = je.getAsInt();
                je = cfg.get("thickness");
                si.thiccness = je == null ? 6 : je.getAsInt();
                JsonElement connected_textures = cfg.get("connected_textures");
                si.connectTextures = connected_textures == null || connected_textures.getAsBoolean();
                try {
                    solars.register((IForgeRegistryEntry)si);
                    BlockBaseSolar block = si.getBlock();
                    blocks.register((IForgeRegistryEntry)block);
                    ItemBlock model = new ItemBlock((Block)block);
                    model.setRegistryName(block.getRegistryName());
                    items.register((IForgeRegistryEntry)model);
                    SolarFluxAPI.renderRenderer.accept((Item)model);
                }
                catch (Throwable thr) {
                    thr.printStackTrace();
                }
            }
            catch (IOException ioe) {
                ioe.printStackTrace();
            }
        }
    }

    public static void reloadConfigs() {
        IForgeRegistry<SolarInfo> infos = SolarFluxAPI.SOLAR_PANELS;
        for (SolarInfo si : infos.getValuesCollection()) {
            Throwable throwable;
            File f;
            si.getBlock().func_149647_a(SolarFluxAPI.tab);
            ResourceLocation rn = si.getRegistryName();
            if (si.isCustom) {
                f = new File(SolarsSF.getCustomCfgDir(), si.getRegistryName().func_110623_a() + File.separator + "panel.json");
            } else {
                f = new File(cfgDir, si.getCompatMod() != null ? si.getCompatMod() : rn.func_110624_b());
                if (!f.isDirectory()) {
                    f.mkdirs();
                }
                f = new File(f, rn.func_110623_a().replaceAll("/", "_") + ".json");
            }
            if (!f.isFile()) {
                try {
                    throwable = null;
                    try (FileWriter j = new FileWriter(f);){
                        j.append('{');
                        String nln = System.lineSeparator() + "\t";
                        char s = '\"';
                        j.append(nln + s + "capacity" + s + ": " + si.maxCapacity + ",");
                        j.append(nln + s + "generation" + s + ": " + si.maxGeneration + ",");
                        j.append(nln + s + "transfer" + s + ": " + si.maxTransfer + ",");
                        j.append(nln + s + "thickness" + s + ": " + si.thiccness + ",");
                        j.append(nln + s + "connected_textures" + s + ": " + si.connectTextures + System.lineSeparator());
                        j.append('}');
                        j.flush();
                    }
                    catch (Throwable nln) {
                        throwable = nln;
                        throw nln;
                    }
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
            try {
                InputStreamReader reader = new InputStreamReader((InputStream)new FileInputStream(f), StandardCharsets.UTF_8);
                throwable = null;
                try {
                    JsonElement localsElem;
                    JsonStreamParser j = new JsonStreamParser((Reader)reader);
                    JsonObject cfg = j.next().getAsJsonObject();
                    si.maxCapacity = cfg.get("capacity").getAsLong();
                    si.maxGeneration = cfg.get("generation").getAsLong();
                    si.maxTransfer = cfg.get("transfer").getAsInt();
                    JsonElement thickness = cfg.get("thickness");
                    si.thiccness = thickness == null ? 6 : thickness.getAsInt();
                    JsonElement connected_textures = cfg.get("connected_textures");
                    boolean bl = si.connectTextures = connected_textures == null || connected_textures.getAsBoolean();
                    if (!si.isCustom || (localsElem = cfg.get("localizations")) == null) continue;
                    JsonObject locals = localsElem.getAsJsonObject();
                    HashMap<String, String> lmap = new HashMap<String, String>();
                    for (Map.Entry langs : locals.entrySet()) {
                        lmap.put(((String)langs.getKey()).toLowerCase(), ((JsonElement)langs.getValue()).getAsString());
                    }
                    si.localizations = Collections.unmodifiableMap(lmap);
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    if (reader == null) continue;
                    if (throwable != null) {
                        try {
                            reader.close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                        continue;
                    }
                    reader.close();
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }
}

