/*
 * Decompiled with CFR 0.152.
 */
package me.time6628.clag.sponge;

import com.google.inject.Inject;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.TimeUnit;
import me.time6628.clag.sponge.api.CCLService;
import me.time6628.clag.sponge.api.Type;
import me.time6628.clag.sponge.commands.CLDebugCommand;
import me.time6628.clag.sponge.commands.ForceGCCommand;
import me.time6628.clag.sponge.commands.LaggyChunksCommand;
import me.time6628.clag.sponge.commands.RemoveEntitiesCommand;
import me.time6628.clag.sponge.commands.UnloadChunksCommand;
import me.time6628.clag.sponge.commands.WhiteListItemCommand;
import me.time6628.clag.sponge.config.CCLConfig;
import me.time6628.clag.sponge.config.ConfigLoader;
import me.time6628.clag.sponge.config.MessagesConfig;
import me.time6628.clag.sponge.handlers.ItemManager;
import me.time6628.clag.sponge.handlers.MobEventHandler;
import me.time6628.clag.sponge.runnables.EntityChecker;
import me.time6628.clag.sponge.runnables.ItemClearer;
import me.time6628.clag.sponge.runnables.ItemClearingWarning;
import ninja.leaping.configurate.objectmapping.GuiceObjectMapperFactory;
import org.slf4j.Logger;
import org.spongepowered.api.Game;
import org.spongepowered.api.Sponge;
import org.spongepowered.api.command.CommandCallable;
import org.spongepowered.api.config.ConfigDir;
import org.spongepowered.api.event.Listener;
import org.spongepowered.api.event.game.GameReloadEvent;
import org.spongepowered.api.event.game.state.GameInitializationEvent;
import org.spongepowered.api.event.game.state.GamePreInitializationEvent;
import org.spongepowered.api.plugin.Plugin;
import org.spongepowered.api.scheduler.Scheduler;
import org.spongepowered.api.scheduler.Task;
import org.spongepowered.api.service.pagination.PaginationService;
import org.spongepowered.api.world.Chunk;

@Plugin(name="CatClearLag", id="catclearlag", version="0.9.0", description="A plugin to assist in removing lag from your server.")
public class CatClearLag {
    public static CatClearLag instance;
    private final Logger logger;
    private final File configDir;
    private final Game game;
    private final GuiceObjectMapperFactory factory;
    private final CCLService cclService;
    private ConfigLoader cfgLoader;
    private MessagesConfig messages;
    private CCLConfig cclConfig;
    private List<Task> tasks;
    private ItemManager itemManager;

    @Inject
    public CatClearLag(Logger logger, Game game, @ConfigDir(sharedRoot=false) File configDir, GuiceObjectMapperFactory factory) {
        this.logger = logger;
        this.game = game;
        this.configDir = configDir;
        this.factory = factory;
        instance = this;
        this.cclService = new CCLService();
    }

    public MessagesConfig getMessagesCfg() {
        return this.messages;
    }

    public CCLConfig getCclConfig() {
        return this.cclConfig;
    }

    @Listener
    public void onPreInit(GamePreInitializationEvent event) {
        this.getLogger().info("Setting up config...");
        this.cfgLoader = new ConfigLoader(this);
        if (this.cfgLoader.loadConfig()) {
            this.cclConfig = this.cfgLoader.getCclConfig();
        }
        if (this.cfgLoader.loadMessages()) {
            this.messages = this.cfgLoader.getMessagesConfig();
        }
        this.game.getServiceManager().setProvider((Object)this, CCLService.class, (Object)this.cclService);
    }

    @Listener
    public void onReload(GameReloadEvent event) {
        this.cfgLoader = new ConfigLoader(this);
        if (this.cfgLoader.loadConfig()) {
            this.cclConfig = this.cfgLoader.getCclConfig();
        }
        if (this.cfgLoader.loadMessages()) {
            this.messages = this.cfgLoader.getMessagesConfig();
        }
        for (Task task : this.tasks) {
            task.cancel();
        }
        this.tasks = new ArrayList<Task>();
        Task.Builder builder = this.getGame().getScheduler().createTaskBuilder();
        this.tasks.add(builder.execute((Runnable)new ItemClearer()).delay((long)this.cclConfig.interval, TimeUnit.MINUTES).interval((long)this.cclConfig.interval, TimeUnit.MINUTES).name("CatClearLag Item Remover").submit((Object)this));
        this.cclConfig.warnings.forEach(d -> this.tasks.add(builder.execute((Runnable)new ItemClearingWarning(this.cclConfig.interval * 60 - d)).async().delay((long)d.intValue(), TimeUnit.SECONDS).interval((long)this.cclConfig.interval, TimeUnit.MINUTES).name("CatClearLag Removal Warnings").submit((Object)this)));
        this.tasks.add(builder.execute((Runnable)new EntityChecker()).delay((long)this.cclConfig.limits.entityCheckInterval, TimeUnit.MINUTES).interval((long)this.cclConfig.limits.entityCheckInterval, TimeUnit.MINUTES).name("CatClearLag hostile checker").submit((Object)this));
    }

    @Listener
    public void onInit(GameInitializationEvent event) {
        this.getLogger().info("Starting plugin...");
        this.registerCommands();
        this.registerEvents();
        this.tasks = new ArrayList<Task>();
        if (this.cclConfig.liveTime.enabled) {
            this.itemManager = new ItemManager();
            this.getGame().getEventManager().registerListeners((Object)this, (Object)this.itemManager);
            this.getCclService().addCheck(Type.ITEM, entity -> !this.itemManager.getItems().contains(entity));
        }
        Scheduler scheduler = this.getGame().getScheduler();
        if (this.getCclConfig().interval != -1) {
            this.tasks.add(scheduler.createTaskBuilder().execute((Runnable)new ItemClearer()).delay((long)this.cclConfig.interval, TimeUnit.MINUTES).interval((long)this.cclConfig.interval, TimeUnit.MINUTES).name("CatClearLag Item Remover").submit((Object)this));
            this.cclConfig.warnings.forEach(d -> this.tasks.add(scheduler.createTaskBuilder().execute((Runnable)new ItemClearingWarning(this.cclConfig.interval * 60 - d)).async().delay((long)d.intValue(), TimeUnit.SECONDS).interval((long)this.cclConfig.interval, TimeUnit.MINUTES).name("CatClearLag Removal Warnings").submit((Object)this)));
        }
        this.tasks.add(scheduler.createTaskBuilder().execute((Runnable)new EntityChecker()).delay((long)this.cclConfig.limits.entityCheckInterval, TimeUnit.MINUTES).interval((long)this.cclConfig.limits.entityCheckInterval, TimeUnit.MINUTES).name("CatClearLag hostile checker").submit((Object)this));
    }

    private void registerEvents() {
        if (this.getCclConfig().limits.perChunkLimitEnabled) {
            Sponge.getEventManager().registerListeners((Object)this, (Object)new MobEventHandler());
        }
    }

    private void registerCommands() {
        this.getLogger().info("Registering commands...");
        Sponge.getCommandManager().register((Object)this, (CommandCallable)RemoveEntitiesCommand.getCommand(), new String[]{"re"});
        Sponge.getCommandManager().register((Object)this, (CommandCallable)ForceGCCommand.getCommand(), new String[]{"forcegc", "forcegarbagecollection"});
        Sponge.getCommandManager().register((Object)this, (CommandCallable)LaggyChunksCommand.getCommand(), new String[]{"laggychunks", "lc"});
        Sponge.getCommandManager().register((Object)this, (CommandCallable)WhiteListItemCommand.getCommand(), new String[]{"clwhitelist", "cwl"});
        Sponge.getCommandManager().register((Object)this, (CommandCallable)UnloadChunksCommand.getCommand(), new String[]{"unloadchunks", "uc"});
        Sponge.getCommandManager().register((Object)this, (CommandCallable)CLDebugCommand.getCommand(), new String[]{"cldebug"});
    }

    public Logger getLogger() {
        return this.logger;
    }

    public PaginationService getPaginationService() {
        return (PaginationService)this.game.getServiceManager().provide(PaginationService.class).get();
    }

    private List<Chunk> getChunks() {
        ArrayList<Chunk> chunks = new ArrayList<Chunk>();
        Collection worlds = Sponge.getServer().getWorlds();
        worlds.forEach(temp -> {
            Collection tempLoadedChunks = (Collection)temp.getLoadedChunks();
            chunks.addAll(tempLoadedChunks);
        });
        return chunks;
    }

    public Integer unloadChunks() {
        int[] i = new int[]{0};
        List<Chunk> chunks = this.getChunks();
        chunks.forEach(chunk -> {
            chunk.unloadChunk();
            i[0] = i[0] + 1;
        });
        return i[0];
    }

    public void addIDToWhiteList(String id) {
        this.logger.info("adding " + id + " to the whitelist.");
        this.cclConfig.whitelist.add(id);
        this.cfgLoader.saveConfig(this.cclConfig);
        this.cclConfig = this.cfgLoader.getCclConfig();
    }

    public Integer getMobLimitPerChunk() {
        return this.cclConfig.limits.mobLimitPerChunk;
    }

    public int getHostileLimit() {
        return this.cclConfig.limits.hostileLimit;
    }

    public Game getGame() {
        return this.game;
    }

    public int getXpOrbLimit() {
        return this.cclConfig.limits.maxXPOrbs;
    }

    public File getConfigDir() {
        return this.configDir;
    }

    public GuiceObjectMapperFactory getFactory() {
        return this.factory;
    }

    public CCLService getCclService() {
        return this.cclService;
    }

    public boolean isBossBarEnabled() {
        return this.cclConfig.bossBar.enabled;
    }
}

