/*
 * Decompiled with CFR 0.152.
 */
package me.time6628.clag.sponge;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import me.time6628.clag.sponge.api.Type;
import me.time6628.clag.sponge.api.events.ClearLagEvent;
import org.spongepowered.api.Sponge;
import org.spongepowered.api.entity.Entity;
import org.spongepowered.api.event.Event;

public class EntityRemover<C extends Entity> {
    private final Predicate<Entity> predicate;
    private final Type type;

    public EntityRemover(Predicate<Entity> checks, Type type) {
        this.predicate = checks;
        this.type = type;
    }

    public List<C> getEntities() {
        ArrayList entities = new ArrayList();
        Collection worlds = Sponge.getServer().getWorlds();
        worlds.forEach(temp -> {
            Collection w = temp.getEntities().stream().filter(this.predicate).collect(Collectors.toList());
            entities.addAll(w);
        });
        return entities;
    }

    public int removeEntities() {
        boolean cancelled = Sponge.getEventManager().post((Event)new ClearLagEvent.Pre(this.type));
        if (cancelled) {
            return -1;
        }
        int[] i = new int[]{0};
        this.getEntities().forEach(c -> {
            c.remove();
            i[0] = i[0] + 1;
        });
        Sponge.getEventManager().post((Event)new ClearLagEvent.Post(this.type, i[0]));
        return i[0];
    }
}

