/*
 * Decompiled with CFR 0.152.
 */
package me.time6628.clag.sponge.api;

import java.util.EnumMap;
import java.util.Map;
import java.util.function.Predicate;
import me.time6628.clag.sponge.CatClearLag;
import me.time6628.clag.sponge.api.Type;
import org.spongepowered.api.data.key.Keys;
import org.spongepowered.api.entity.Entity;
import org.spongepowered.api.entity.ExperienceOrb;
import org.spongepowered.api.entity.Item;
import org.spongepowered.api.entity.living.Hostile;
import org.spongepowered.api.entity.living.Living;
import org.spongepowered.api.entity.living.animal.Animal;
import org.spongepowered.api.entity.living.player.Player;

public class CCLService {
    private final Map<Type, Predicate<Entity>> checks = new EnumMap<Type, Predicate<Entity>>(Type.class);

    public CCLService() {
        Predicate<Entity> whitelistCheck = item -> !CatClearLag.instance.getCclConfig().whitelist.contains(((Item)item).getItemType().getId());
        Predicate<Entity> entityWhitelist = entity -> !CatClearLag.instance.getCclConfig().entityWhiteList.contains(entity.getType().getId());
        this.checks.put(Type.HOSTILE, this.notAPlayer().and(o -> o instanceof Hostile).and(entityWhitelist));
        this.checks.put(Type.ITEM, this.notAPlayer().and(o -> o instanceof Item && o.get(Keys.DESPAWN_DELAY).isPresent() && (Integer)o.get(Keys.DESPAWN_DELAY).get() < CatClearLag.instance.getCclConfig().itemDespawnRate).and(whitelistCheck));
        this.checks.put(Type.ALL, this.notAPlayer().and(Entity.class::isInstance).and(entityWhitelist));
        this.checks.put(Type.LIVING, this.notAPlayer().and(o -> o instanceof Living).and(entityWhitelist));
        this.checks.put(Type.XP, this.notAPlayer().and(o -> o instanceof ExperienceOrb));
        this.checks.put(Type.ANIMAL, this.notAPlayer().and(o -> o instanceof Animal).and(entityWhitelist));
        this.checks.put(Type.NAMED, this.notAPlayer().and(entity -> !entity.get(Keys.DISPLAY_NAME).isPresent() && entity.get(Keys.PERSISTS).isPresent() && (Boolean)entity.get(Keys.PERSISTS).get() == false && !entity.get(Keys.TAMED_OWNER).isPresent()));
        this.checks.put(Type.ENTITY, this.notAPlayer());
    }

    private Predicate<Entity> notAPlayer() {
        return entity -> !(entity instanceof Player);
    }

    public Predicate<Entity> addCheck(Type type, Predicate<Entity> predicateToAdd) {
        return this.checks.put(type, this.checks.get((Object)type).and(predicateToAdd));
    }

    public Predicate<Entity> removeCheck(Type type, Predicate<Entity> predicateToRemove) {
        return this.checks.put(type, this.checks.get((Object)type).and(predicateToRemove.negate()));
    }

    public Predicate<Entity> getPredicate(Type type) {
        return this.checks.get((Object)type);
    }
}

