/*
 * Decompiled with CFR 0.152.
 */
package me.time6628.clag.sponge.handlers;

import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import me.time6628.clag.sponge.CatClearLag;
import org.spongepowered.api.entity.Entity;
import org.spongepowered.api.entity.Item;
import org.spongepowered.api.event.Listener;
import org.spongepowered.api.event.filter.Getter;
import org.spongepowered.api.event.filter.IsCancelled;
import org.spongepowered.api.event.item.inventory.ChangeInventoryEvent;
import org.spongepowered.api.event.item.inventory.DropItemEvent;
import org.spongepowered.api.scheduler.SpongeExecutorService;
import org.spongepowered.api.util.Tristate;

public class ItemManager {
    private final CatClearLag plugin = CatClearLag.instance;
    private final Set<Item> items = new HashSet<Item>();
    private final Map<Item, SpongeExecutorService.SpongeFuture> futures = new HashMap<Item, SpongeExecutorService.SpongeFuture>();

    @Listener
    @IsCancelled(value=Tristate.FALSE)
    public void onEntitySpawn(DropItemEvent.Dispense event, @Getter(value="getEntities") List<Entity> entity) {
        entity.forEach(entity1 -> {
            this.items.add((Item)entity1);
            SpongeExecutorService.SpongeFuture future = this.plugin.getGame().getScheduler().createAsyncExecutor((Object)this.plugin).schedule(() -> this.items.remove(entity1), (long)this.plugin.getCclConfig().liveTime.minLiveTime, TimeUnit.SECONDS);
            this.futures.put((Item)entity1, future);
        });
    }

    @Listener
    @IsCancelled(value=Tristate.FALSE)
    public void onEntityDespawn(ChangeInventoryEvent.Pickup.Pre event, @Getter(value="getTargetEntity") Item entity) {
        this.futures.remove(entity).getTask().cancel();
    }

    public Set<Item> getItems() {
        return this.items;
    }
}

