/*
 * Decompiled with CFR 0.152.
 */
package me.time6628.clag.sponge.runnables;

import java.util.concurrent.TimeUnit;
import me.time6628.clag.sponge.CatClearLag;
import me.time6628.clag.sponge.Messages;
import me.time6628.clag.sponge.runnables.ItemClearingWarning;
import me.time6628.clag.sponge.utils.EntityHelpers;
import org.spongepowered.api.entity.living.player.Player;
import org.spongepowered.api.text.Text;
import org.spongepowered.api.text.chat.ChatTypes;

public class ItemClearer
implements Runnable {
    private final CatClearLag plugin = CatClearLag.instance;

    @Override
    public void run() {
        int i = EntityHelpers.clearGroundItems();
        if (i == -1) {
            this.plugin.getLogger().info("Another plugin has cancelled the auto clearing of items.");
            return;
        }
        Text message = Messages.getClearMsg(i);
        Text messageRaw = Messages.getClearMsg(i, false);
        if (this.plugin.isBossBarEnabled() && ItemClearingWarning.bossBar != null) {
            ItemClearingWarning.bossBar.setName(messageRaw);
            ItemClearingWarning.bossBar.setPercent(0.0f);
        }
        for (Player player : this.plugin.getGame().getServer().getOnlinePlayers()) {
            if (this.plugin.getCclConfig().sounds.enabled) {
                player.playSound(this.plugin.getCclConfig().sounds.clearedSound, this.plugin.getCclConfig().sounds.soundCategory, player.getPosition(), 25.0);
            }
            if (!this.plugin.getMessagesCfg().actionBar) continue;
            player.sendMessage(ChatTypes.ACTION_BAR, messageRaw);
        }
        this.plugin.getGame().getServer().getBroadcastChannel().send(message);
        if (this.plugin.isBossBarEnabled()) {
            ItemClearingWarning.bossBarUpdater.cancel(true);
            this.plugin.getGame().getScheduler().createTaskBuilder().execute(() -> {
                if (ItemClearingWarning.bossBar.getPercent() == 0.0f) {
                    ItemClearingWarning.bossBar.setVisible(false);
                    ItemClearingWarning.bossBar = null;
                }
            }).delay((long)this.plugin.getCclConfig().bossBar.hideBoss, TimeUnit.SECONDS).async().submit((Object)this.plugin);
        }
    }
}

