/*
 * Decompiled with CFR 0.152.
 */
package me.time6628.clag.sponge.runnables;

import java.util.Collection;
import java.util.concurrent.TimeUnit;
import me.time6628.clag.sponge.CatClearLag;
import me.time6628.clag.sponge.Messages;
import org.spongepowered.api.boss.BossBarOverlays;
import org.spongepowered.api.boss.ServerBossBar;
import org.spongepowered.api.entity.living.player.Player;
import org.spongepowered.api.scheduler.SpongeExecutorService;
import org.spongepowered.api.text.Text;
import org.spongepowered.api.text.chat.ChatTypes;

public class ItemClearingWarning
implements Runnable {
    public static ServerBossBar bossBar;
    public static SpongeExecutorService.SpongeFuture<?> bossBarUpdater;
    private final int seconds;
    private final CatClearLag plugin = CatClearLag.instance;

    public ItemClearingWarning(int seconds) {
        this.seconds = seconds;
    }

    @Override
    public void run() {
        Text message = Messages.getWarningMsg(this.seconds);
        Text rawMessage = Messages.getWarningMsg(this.seconds, false);
        Collection onlinePlayers = this.plugin.getGame().getServer().getOnlinePlayers();
        if (this.plugin.isBossBarEnabled() && (bossBar == null || !bossBar.isVisible())) {
            bossBar = ServerBossBar.builder().color(this.plugin.getCclConfig().bossBar.bossBarColor).darkenSky(false).createFog(false).playEndBossMusic(false).percent(1.0f).name(rawMessage).visible(true).overlay(BossBarOverlays.PROGRESS).build();
            bossBar.addPlayers(onlinePlayers);
            bossBarUpdater = this.plugin.getGame().getScheduler().createAsyncExecutor((Object)this.plugin).scheduleAtFixedRate(() -> {
                if (bossBar != null) {
                    bossBar.setPercent(bossBar.getPercent() - 1.0f / (float)this.seconds);
                    bossBar.setName(Messages.getWarningMsg((int)((float)this.seconds * bossBar.getPercent()), false));
                }
            }, 1L, 1L, TimeUnit.SECONDS);
        }
        for (Player player : onlinePlayers) {
            if (this.plugin.getCclConfig().sounds.enabled) {
                player.playSound(this.plugin.getCclConfig().sounds.warningSound, this.plugin.getCclConfig().sounds.soundCategory, player.getPosition(), 25.0);
            }
            if (!this.plugin.getMessagesCfg().actionBar) continue;
            player.sendMessage(ChatTypes.ACTION_BAR, rawMessage);
        }
        this.plugin.getGame().getServer().getBroadcastChannel().send(message);
    }
}

