/*
 * Decompiled with CFR 0.152.
 */
package rovearix.cratedrops;

import com.google.inject.Inject;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.nio.file.Path;
import java.util.HashMap;
import java.util.Objects;
import java.util.Optional;
import java.util.Timer;
import java.util.TimerTask;
import ninja.leaping.configurate.ConfigurationNode;
import ninja.leaping.configurate.commented.CommentedConfigurationNode;
import ninja.leaping.configurate.hocon.HoconConfigurationLoader;
import ninja.leaping.configurate.loader.ConfigurationLoader;
import org.slf4j.Logger;
import org.spongepowered.api.Sponge;
import org.spongepowered.api.asset.Asset;
import org.spongepowered.api.block.BlockTypes;
import org.spongepowered.api.command.CommandCallable;
import org.spongepowered.api.command.CommandSource;
import org.spongepowered.api.command.args.CommandElement;
import org.spongepowered.api.command.args.GenericArguments;
import org.spongepowered.api.command.spec.CommandExecutor;
import org.spongepowered.api.command.spec.CommandSpec;
import org.spongepowered.api.config.DefaultConfig;
import org.spongepowered.api.effect.particle.ParticleEffect;
import org.spongepowered.api.effect.particle.ParticleTypes;
import org.spongepowered.api.entity.living.player.Player;
import org.spongepowered.api.event.Listener;
import org.spongepowered.api.event.block.InteractBlockEvent;
import org.spongepowered.api.event.filter.cause.Root;
import org.spongepowered.api.event.game.GameReloadEvent;
import org.spongepowered.api.event.game.state.GameInitializationEvent;
import org.spongepowered.api.event.game.state.GamePreInitializationEvent;
import org.spongepowered.api.event.game.state.GameStartedServerEvent;
import org.spongepowered.api.plugin.Dependency;
import org.spongepowered.api.plugin.Plugin;
import org.spongepowered.api.text.Text;
import org.spongepowered.api.text.serializer.TextSerializers;
import org.spongepowered.api.world.Location;
import org.spongepowered.api.world.World;
import org.spongepowered.api.world.extent.Extent;
import rovearix.cratedrops.commands.ActiveCratesCommand;
import rovearix.cratedrops.commands.DropCrateCommand;
import rovearix.cratedrops.tasks.CrateDropTask;

@Plugin(id="cratedrops", name="CrateDrops", version="1.3", description="Plugin that spawns in a crate at a random location", url="https://ore.spongepowered.org/rovearix/CrateDrops/", authors={"Rovearix"}, dependencies={@Dependency(id="nucleus"), @Dependency(id="griefpervention", optional=true)})
public class CrateDrops {
    @Inject
    @DefaultConfig(sharedRoot=false)
    public Path defaultConfig;
    @Inject
    @DefaultConfig(sharedRoot=false)
    private ConfigurationLoader<CommentedConfigurationNode> configManager;
    private ConfigurationNode config;
    @Inject
    private Logger logger;
    private static CrateDrops instance;
    private Timer autoDropTimer;
    public static CommandSpec dropCrateSpec;
    public static CommandSpec activeCratesSpec;

    public ConfigurationNode getConfig() {
        return this.config;
    }

    public Logger getLogger() {
        return this.logger;
    }

    @Listener
    public void onPreInitialization(GamePreInitializationEvent event) throws IOException {
        this.logger.info("Starting up CrateDrops.");
        ((Asset)Sponge.getAssetManager().getAsset((Object)this, "cratedrops.conf").get()).copyToFile(this.defaultConfig, false, true);
        this.configManager = ((HoconConfigurationLoader.Builder)HoconConfigurationLoader.builder().setPath(this.defaultConfig)).build();
        this.config = this.configManager.load();
    }

    @Listener
    public void onInitialization(GameInitializationEvent event) {
        instance = this;
    }

    @Listener
    public void onServerStart(GameStartedServerEvent event) {
        Sponge.getCommandManager().register((Object)this, (CommandCallable)dropCrateSpec, new String[]{"dropcrate"});
        Sponge.getCommandManager().register((Object)this, (CommandCallable)activeCratesSpec, new String[]{"activecrates"});
        DropCrateCommand.database = CrateDrops.offlineDBContents();
        this.scheduleDrop();
    }

    @Listener
    public void onPluginReload(GameReloadEvent event) throws IOException {
        ((Asset)Sponge.getAssetManager().getAsset((Object)this, "cratedrops.conf").get()).copyToFile(this.defaultConfig, false, true);
        this.config = this.configManager.load();
        DropCrateCommand.database = CrateDrops.offlineDBContents();
        this.scheduleDrop();
    }

    public static CrateDrops getInstance() {
        return instance;
    }

    @Listener
    public void onBlockInteract(InteractBlockEvent event, @Root Player source) {
        try {
            Optional blockLoc = event.getTargetBlock().getLocation();
            for (Location<World> location : DropCrateCommand.database.keySet()) {
                if (!blockLoc.isPresent() || !location.equals(blockLoc.get())) continue;
                String crate = DropCrateCommand.database.get(location);
                String kit = this.config.getNode(new Object[]{"config", "crates", crate, "kit-name"}).getString();
                Sponge.getCommandManager().process((CommandSource)Sponge.getServer().getConsole(), "kit give " + source.getName() + " " + kit);
                location.removeBlock();
                DropCrateCommand.database.remove(location);
                CrateDrops.removeFromOffline((Location<World>)((Location)blockLoc.get()));
                ParticleEffect effect = ParticleEffect.builder().type(ParticleTypes.FIREWORKS).quantity(10).build();
                source.spawnParticles(effect, location.getPosition());
                String rawMessage = Objects.requireNonNull(this.config.getNode(new Object[]{"config", "found-message"}).getString());
                rawMessage = rawMessage.replace("{X}", Integer.toString(location.getBlockX()));
                rawMessage = rawMessage.replace("{Y}", Integer.toString(location.getBlockY()));
                rawMessage = rawMessage.replace("{Z}", Integer.toString(location.getBlockZ()));
                rawMessage = rawMessage.replace("{PLAYER}", source.getName());
                rawMessage = rawMessage.replace("{CRATE}", CrateDrops.cratePretty(crate));
                Text message = TextSerializers.FORMATTING_CODE.deserialize(rawMessage);
                for (Player player : Sponge.getServer().getOnlinePlayers()) {
                    player.sendMessage(message);
                }
                CrateDrops.getInstance().getLogger().info(message.toPlain());
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static String cratePretty(String crate) {
        String crateMsg = crate.substring(0, 1).toUpperCase() + crate.toLowerCase().substring(1);
        CharSequence[] crateChunks = crateMsg.split("-");
        for (int i = 0; i < crateChunks.length; ++i) {
            String word = crateChunks[i].substring(0, 1).toUpperCase();
            crateChunks[i] = ((String)crateChunks[i]).length() > 1 ? word + ((String)crateChunks[i]).substring(1) : word;
        }
        return String.join((CharSequence)" ", crateChunks);
    }

    public static HashMap<Location<World>, String> offlineDBContents() {
        World world;
        HashMap<Location<World>, String> database = new HashMap<Location<World>, String>();
        try {
            world = (World)Sponge.getServer().getWorld(Objects.requireNonNull(CrateDrops.getInstance().getConfig().getNode(new Object[]{"config", "world-name"}).getString())).get();
        }
        catch (Exception e) {
            CrateDrops.getInstance().getLogger().info("Invalid world selected in the config.");
            return null;
        }
        try {
            BufferedReader reader = new BufferedReader(new FileReader(CrateDrops.getInstance().defaultConfig.toFile().getParent() + File.separator + "offline.db"));
            String crateRaw = reader.readLine();
            while (crateRaw != null) {
                String[] crateData = crateRaw.split(",");
                int x = Integer.parseInt(crateData[0]);
                int y = Integer.parseInt(crateData[1]);
                int z = Integer.parseInt(crateData[2]);
                String crate = crateData[3];
                Location crateLoc = new Location((Extent)world, x, y, z);
                crateLoc.setBlockType(BlockTypes.TRAPPED_CHEST);
                database.put((Location<World>)crateLoc, crate);
                crateRaw = reader.readLine();
            }
            reader.close();
        }
        catch (FileNotFoundException e) {
            CrateDrops.getInstance().getLogger().info("No offline data found, skipping import.");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return database;
    }

    public static boolean removeFromOffline(Location<World> location) {
        boolean removed = false;
        try {
            File offlineDB = new File(CrateDrops.getInstance().defaultConfig.toFile().getParent() + File.separator + "offline.db");
            File tempDB = new File(CrateDrops.getInstance().defaultConfig.toFile().getParent() + File.separator + "tempOffline.db");
            BufferedReader reader = new BufferedReader(new FileReader(offlineDB));
            BufferedWriter writer = new BufferedWriter(new FileWriter(tempDB));
            String crateRaw = reader.readLine();
            while (crateRaw != null) {
                String[] crateData = crateRaw.split(",");
                if (Integer.parseInt(crateData[0]) == location.getBlockX() && Integer.parseInt(crateData[1]) == location.getBlockY() && Integer.parseInt(crateData[2]) == location.getBlockZ()) {
                    removed = true;
                    crateRaw = reader.readLine();
                    continue;
                }
                writer.write(crateRaw + "\n");
                crateRaw = reader.readLine();
            }
            writer.close();
            reader.close();
            offlineDB.delete();
            tempDB.renameTo(offlineDB);
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
        return removed;
    }

    public void scheduleDrop() {
        if (this.autoDropTimer != null) {
            this.autoDropTimer.cancel();
        }
        if (this.config.getNode(new Object[]{"config", "auto-drop", "enabled"}).getBoolean()) {
            this.autoDropTimer = new Timer();
            long time = this.getConfigScheduleTime();
            if (time != -1L) {
                this.autoDropTimer.schedule((TimerTask)new CrateDropTask(this), time);
                String rawMessage = Objects.requireNonNull(this.config.getNode(new Object[]{"config", "auto-drop", "auto-message"}).getString());
                rawMessage = rawMessage.replace("{TIME}", this.convertTime(time));
                Text message = TextSerializers.FORMATTING_CODE.deserialize(rawMessage);
                this.logger.info(message.toPlain());
                if (this.config.getNode(new Object[]{"config", "auto-drop", "broadcast-auto"}).getBoolean()) {
                    for (Player player : Sponge.getServer().getOnlinePlayers()) {
                        player.sendMessage(message);
                    }
                }
            } else {
                this.logger.info("Invalid time in config, disabling auto drop.");
            }
        }
    }

    public long getConfigScheduleTime() {
        long time = 0L;
        String timeRaw = this.config.getNode(new Object[]{"config", "auto-drop", "interval"}).getString();
        timeRaw = Objects.requireNonNull(timeRaw).replaceAll(" ", "").toLowerCase();
        int num = 0;
        for (int i = 0; i < timeRaw.length(); ++i) {
            char c = timeRaw.charAt(i);
            if (Character.isDigit(c)) {
                num *= 10;
                num += Character.getNumericValue(c);
                continue;
            }
            if ("dhms".indexOf(c) != -1) {
                if (c == 'd') {
                    time += (long)(num * 24 * 60 * 60 * 1000);
                } else if (c == 'h') {
                    time += (long)(num * 60 * 60 * 1000);
                } else if (c == 'm') {
                    time += (long)(num * 60 * 1000);
                } else if (c == 's') {
                    time += (long)(num * 1000);
                }
                num = 0;
                continue;
            }
            return -1L;
        }
        return num == 0 ? time : -1L;
    }

    public String convertTime(long time) {
        long current;
        String timeReal = "";
        if (time / 86400000L > 0L) {
            current = time / 86400000L;
            timeReal = timeReal + current + " Day";
            if (current > 1L) {
                timeReal = timeReal + "s";
            }
            time %= 86400000L;
        }
        if (time / 3600000L > 0L) {
            current = time / 3600000L;
            timeReal = timeReal + " " + current + " Hour";
            if (current > 1L) {
                timeReal = timeReal + "s";
            }
            time %= 3600000L;
        }
        if (time / 60000L > 0L) {
            current = time / 60000L;
            timeReal = timeReal + " " + current + " Minute";
            if (current > 1L) {
                timeReal = timeReal + "s";
            }
            time %= 60000L;
        }
        if (time / 1000L > 0L) {
            current = time / 1000L;
            timeReal = timeReal + " " + current + " Second";
            if (current > 1L) {
                timeReal = timeReal + "s";
            }
        }
        return timeReal.trim();
    }

    static {
        dropCrateSpec = CommandSpec.builder().description((Text)Text.of((String)"/dropcrate [amount] [crate name] Drops crates randomly in the wild, default amount: 1, default crate: random.")).permission("dropcrate.command.dropcrate").arguments(new CommandElement[]{GenericArguments.optionalWeak((CommandElement)GenericArguments.integer((Text)Text.of((String)"amount"))), GenericArguments.optionalWeak((CommandElement)GenericArguments.string((Text)Text.of((String)"crate")))}).executor((CommandExecutor)new DropCrateCommand()).build();
        activeCratesSpec = CommandSpec.builder().description((Text)Text.of((String)"/activecrates shows a list of all the locations of unclaimed crates in the wild")).permission("dropcrate.command.activecrates").executor((CommandExecutor)new ActiveCratesCommand()).build();
    }
}

