/*
 * Decompiled with CFR 0.152.
 */
package rovearix.cratedrops.commands;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Random;
import ninja.leaping.configurate.ConfigurationNode;
import org.spongepowered.api.Sponge;
import org.spongepowered.api.block.BlockTypes;
import org.spongepowered.api.command.CommandResult;
import org.spongepowered.api.command.CommandSource;
import org.spongepowered.api.command.args.CommandContext;
import org.spongepowered.api.command.spec.CommandExecutor;
import org.spongepowered.api.entity.living.player.Player;
import org.spongepowered.api.text.Text;
import org.spongepowered.api.text.format.TextColors;
import org.spongepowered.api.text.serializer.TextSerializers;
import org.spongepowered.api.world.Location;
import org.spongepowered.api.world.World;
import org.spongepowered.api.world.WorldBorder;
import org.spongepowered.api.world.extent.Extent;
import rovearix.cratedrops.CrateDrops;

public class DropCrateCommand
implements CommandExecutor {
    public static HashMap<Location<World>, String> database = new HashMap();
    public static Random random = new Random();

    public CommandResult execute(CommandSource source, CommandContext args) {
        int amount;
        World world;
        try {
            world = (World)Sponge.getServer().getWorld(Objects.requireNonNull(CrateDrops.getInstance().getConfig().getNode(new Object[]{"config", "world-name"}).getString())).get();
        }
        catch (Exception e) {
            source.sendMessage((Text)Text.builder((String)"Invalid world selected in the config.").color(TextColors.RED).build());
            CrateDrops.getInstance().getLogger().info("Invalid world selected in the config.");
            return CommandResult.success();
        }
        try {
            amount = (Integer)args.getOne("amount").get();
        }
        catch (Exception e) {
            amount = 1;
        }
        for (int crates = 0; crates < amount; ++crates) {
            Location<World> crateLoc = this.newCrateLocation(world);
            while (this.isProtectedBlock(crateLoc)) {
                CrateDrops.getInstance().getLogger().info("Crate drop in GP claim, recalculating!");
                crateLoc = this.newCrateLocation(world);
            }
            crateLoc.setBlockType(BlockTypes.TRAPPED_CHEST);
            String crate = args.getOne("crate").isPresent() ? this.pickCrate((String)args.getOne("crate").get()) : this.pickCrate(null);
            if (crate.charAt(0) == '\u00a7') {
                source.sendMessage((Text)Text.builder((String)crate.substring(1)).color(TextColors.RED).build());
                CrateDrops.getInstance().getLogger().info(crate.substring(1));
                return CommandResult.success();
            }
            database.put(crateLoc, crate);
            try {
                BufferedWriter out = new BufferedWriter(new FileWriter(CrateDrops.getInstance().defaultConfig.toFile().getParent() + File.separator + "offline.db", true));
                out.write(crateLoc.getBlockX() + "," + crateLoc.getBlockY() + "," + crateLoc.getBlockZ() + "," + crate + "\n");
                out.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            if (CrateDrops.getInstance().getConfig().getNode(new Object[]{"config", "buffer", "enabled"}).getBoolean()) {
                int size = CrateDrops.getInstance().getConfig().getNode(new Object[]{"config", "buffer", "size"}).getInt();
                while (size > 0 && database.size() > size) {
                    Location oldLoc = null;
                    try {
                        BufferedReader reader = new BufferedReader(new FileReader(CrateDrops.getInstance().defaultConfig.toFile().getParent() + File.separator + "offline.db"));
                        String crateRaw = reader.readLine();
                        String[] crateData = crateRaw.split(",");
                        oldLoc = new Location((Extent)world, Integer.parseInt(crateData[0]), Integer.parseInt(crateData[1]), Integer.parseInt(crateData[2]));
                        reader.close();
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                    CrateDrops.removeFromOffline(oldLoc);
                    database.remove(oldLoc);
                    oldLoc.removeBlock();
                    String rawMessage = Objects.requireNonNull(CrateDrops.getInstance().getConfig().getNode(new Object[]{"config", "buffer", "expire-message"}).getString());
                    Text message = this.parseMessage(rawMessage, oldLoc.getBlockX(), oldLoc.getBlockY(), oldLoc.getBlockZ(), crate);
                    CrateDrops.getInstance().getLogger().info(message.toPlain());
                    if (!CrateDrops.getInstance().getConfig().getNode(new Object[]{"config", "buffer", "broadcast-expire"}).getBoolean()) continue;
                    for (Player player : Sponge.getServer().getOnlinePlayers()) {
                        player.sendMessage(message);
                    }
                }
            }
            String rawMessage = Objects.requireNonNull(CrateDrops.getInstance().getConfig().getNode(new Object[]{"config", "broadcast-message"}).getString());
            if (CrateDrops.getInstance().getConfig().getNode(new Object[]{"config", "crates", crate, "broadcast-custom"}).getBoolean()) {
                rawMessage = Objects.requireNonNull(CrateDrops.getInstance().getConfig().getNode(new Object[]{"config", "crates", crate, "custom-message"}).getString());
            }
            Text message = this.parseMessage(rawMessage, crateLoc.getBlockX(), crateLoc.getBlockY(), crateLoc.getBlockZ(), crate);
            for (Player player : Sponge.getServer().getOnlinePlayers()) {
                player.sendMessage(message);
            }
            CrateDrops.getInstance().getLogger().info(message.toPlain());
        }
        return CommandResult.success();
    }

    private boolean isProtectedBlock(Location<World> crateLoc) {
        return false;
    }

    public Location<World> newCrateLocation(World world) {
        int z;
        int x;
        WorldBorder border = world.getWorldBorder();
        int borderRadius = (int)Math.floor(border.getDiameter() / 2.0);
        int y = 100;
        if (CrateDrops.getInstance().getConfig().getNode(new Object[]{"config", "restrict-drop", "enabled"}).getBoolean()) {
            int minX = CrateDrops.getInstance().getConfig().getNode(new Object[]{"config", "restrict-drop", "minX"}).getInt();
            int maxX = CrateDrops.getInstance().getConfig().getNode(new Object[]{"config", "restrict-drop", "maxX"}).getInt();
            int minZ = CrateDrops.getInstance().getConfig().getNode(new Object[]{"config", "restrict-drop", "minZ"}).getInt();
            int maxZ = CrateDrops.getInstance().getConfig().getNode(new Object[]{"config", "restrict-drop", "maxZ"}).getInt();
            x = minX + random.nextInt(maxX - minX);
            z = minZ + random.nextInt(maxZ - minZ);
        } else {
            x = border.getCenter().getFloorX() - borderRadius + random.nextInt(borderRadius * 2);
            z = border.getCenter().getFloorZ() - borderRadius + random.nextInt(borderRadius * 2);
        }
        int spawnX = world.getSpawnLocation().getBlockX();
        int spawnZ = world.getSpawnLocation().getBlockZ();
        int spawnRadius = CrateDrops.getInstance().getConfig().getNode(new Object[]{"config", "spawn-radius"}).getInt();
        if (spawnRadius != 0) {
            if (spawnRadius >= borderRadius) {
                CrateDrops.getInstance().getLogger().info("Spawn protection is larger then world border, ignoring.");
            } else {
                while (x > spawnX - spawnRadius && x < spawnX + spawnRadius) {
                    x = border.getCenter().getFloorX() - borderRadius + random.nextInt(borderRadius * 2);
                }
                while (z > spawnZ - spawnRadius && z < spawnZ + spawnRadius) {
                    z = border.getCenter().getFloorZ() - borderRadius + random.nextInt(borderRadius * 2);
                }
            }
        }
        for (int i = 254; i >= 1; --i) {
            if (new Location((Extent)world, x, i, z).getBlockType().equals(BlockTypes.AIR)) continue;
            y = i + 1;
            break;
        }
        return new Location((Extent)world, x, y, z);
    }

    public String pickCrate(String crateOption) {
        if (crateOption != null) {
            if (CrateDrops.getInstance().getConfig().getNode(new Object[]{"config", "crates", crateOption}).isEmpty()) {
                return "\u00a7Crate not found in the config!";
            }
            if (CrateDrops.getInstance().getConfig().getNode(new Object[]{"config", "crates", crateOption, "kit-name"}).isEmpty()) {
                return "\u00a7Crate missing kit-name or blank!";
            }
            return crateOption;
        }
        if (CrateDrops.getInstance().getConfig().getNode(new Object[]{"config", "crates"}).isEmpty()) {
            return "\u00a7No crates in the crates config. Make sure you reload after edit.";
        }
        int chanceTotal = 0;
        HashMap<String, Integer> crateChances = new HashMap<String, Integer>();
        Map crateNodes = CrateDrops.getInstance().getConfig().getNode(new Object[]{"config", "crates"}).getChildrenMap();
        for (ConfigurationNode crateNode : crateNodes.values()) {
            if (crateNode.getNode(new Object[]{"chance"}).getInt() <= 0) continue;
            chanceTotal += crateNode.getNode(new Object[]{"chance"}).getInt();
            crateChances.put((String)crateNode.getKey(), crateNode.getNode(new Object[]{"chance"}).getInt());
        }
        if (crateChances.isEmpty()) {
            return "\u00a7Crates all have a chance of zero percent. Update the config.";
        }
        int selection = random.nextInt(chanceTotal);
        int current = 0;
        for (String key : crateChances.keySet()) {
            if (selection >= current && selection < current + (Integer)crateChances.get(key)) {
                return key;
            }
            current += ((Integer)crateChances.get(key)).intValue();
        }
        return "\u00a7Error, report this to the plugin author.";
    }

    public Text parseMessage(String rawMessage, int x, int y, int z, String crate) {
        rawMessage = rawMessage.replace("{X}", Integer.toString(x));
        rawMessage = rawMessage.replace("{Y}", Integer.toString(y));
        rawMessage = rawMessage.replace("{Z}", Integer.toString(z));
        rawMessage = rawMessage.replace("{CRATE}", CrateDrops.cratePretty(crate));
        return TextSerializers.FORMATTING_CODE.deserialize(rawMessage);
    }
}

