/*
 * Decompiled with CFR 0.152.
 */
package com.ichorpowered.iplog;

import com.google.common.collect.Lists;
import com.google.inject.Inject;
import com.ichorpowered.iplog.JoinListener;
import com.ichorpowered.iplog.Storage;
import com.ichorpowered.iplog.command.AddCommand;
import com.ichorpowered.iplog.command.AliasCommand;
import com.ichorpowered.iplog.command.BaseCommand;
import com.ichorpowered.iplog.command.HelpCommand;
import com.ichorpowered.iplog.command.HistoryCommand;
import com.ichorpowered.iplog.command.IpElement;
import com.ichorpowered.iplog.command.LookupCommand;
import com.ichorpowered.iplog.command.PurgeCommand;
import java.nio.file.Path;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import org.slf4j.Logger;
import org.spongepowered.api.Sponge;
import org.spongepowered.api.command.CommandCallable;
import org.spongepowered.api.command.args.CommandElement;
import org.spongepowered.api.command.args.GenericArguments;
import org.spongepowered.api.command.spec.CommandExecutor;
import org.spongepowered.api.command.spec.CommandSpec;
import org.spongepowered.api.config.ConfigDir;
import org.spongepowered.api.event.Listener;
import org.spongepowered.api.event.game.state.GamePreInitializationEvent;
import org.spongepowered.api.plugin.Plugin;
import org.spongepowered.api.plugin.PluginContainer;
import org.spongepowered.api.text.Text;

@Plugin(id="iplog", name="IPLog", version="0.2.1", description="Connects IP addresses to users, allowing you to catch alternates and similar.", url="http://ichorpowered.com", authors={"Meronat", "IchorPowered"})
public final class IPLog {
    private static IPLog plugin;
    private Logger logger;
    private Storage storage;
    private Path parentPath;
    private PluginContainer pluginContainer;

    @Inject
    public IPLog(Logger logger, @ConfigDir(sharedRoot=false) Path path, PluginContainer pluginContainer) {
        plugin = this;
        this.logger = logger;
        this.parentPath = path;
        this.pluginContainer = pluginContainer;
    }

    @Listener
    public void onGamePreInitialization(GamePreInitializationEvent event) {
        try {
            this.storage = new Storage();
        }
        catch (SQLException e) {
            this.logger.warn("IPLog will not load as it failed to connect or load storage.");
            e.printStackTrace();
            return;
        }
        this.registerCommands();
        Sponge.getEventManager().registerListeners((Object)this, (Object)new JoinListener());
    }

    private void registerCommands() {
        HashMap<ArrayList, CommandSpec> children = new HashMap<ArrayList, CommandSpec>();
        children.put(Lists.newArrayList((Object[])new String[]{"help", "helpme", "?"}), CommandSpec.builder().description((Text)Text.of((String)"Displays command information for IPLog.")).permission("iplog.viewer.help").executor((CommandExecutor)new HelpCommand()).build());
        children.put(Lists.newArrayList((Object[])new String[]{"add", "plus", "create", "put"}), CommandSpec.builder().description((Text)Text.of((String)"Creates a connect between the specified player and IP in the registry.")).permission("iplog.admin.add").arguments(new CommandElement[]{GenericArguments.optional((CommandElement)GenericArguments.onlyOne((CommandElement)GenericArguments.user((Text)Text.of((String)"player")))), GenericArguments.optional((CommandElement)GenericArguments.onlyOne((CommandElement)new IpElement((Text)Text.of((String)"ip"))))}).executor((CommandExecutor)new AddCommand()).build());
        children.put(Lists.newArrayList((Object[])new String[]{"purge", "remove", "delete"}), CommandSpec.builder().description((Text)Text.of((String)"Removes a connection between the specified player and IP in the registry.")).permission("iplog.admin.purge").arguments(new CommandElement[]{GenericArguments.optional((CommandElement)GenericArguments.onlyOne((CommandElement)GenericArguments.user((Text)Text.of((String)"player")))), GenericArguments.optional((CommandElement)GenericArguments.onlyOne((CommandElement)new IpElement((Text)Text.of((String)"ip"))))}).executor((CommandExecutor)new PurgeCommand()).build());
        children.put(Lists.newArrayList((Object[])new String[]{"alias", "alts", "alternates", "related"}), CommandSpec.builder().description((Text)Text.of((String)"Dispays all players associated with the specified player in the registry.")).permission("iplog.viewer.alias").arguments(GenericArguments.optional((CommandElement)GenericArguments.onlyOne((CommandElement)GenericArguments.user((Text)Text.of((String)"player"))))).executor((CommandExecutor)new AliasCommand()).build());
        children.put(Lists.newArrayList((Object[])new String[]{"lookup", "look", "search"}), CommandSpec.builder().description((Text)Text.of((String)"Displays all IPs associated with a player or all players associated with an IP.")).permission("iplog.viewer.lookup").arguments(new CommandElement[]{GenericArguments.optionalWeak((CommandElement)GenericArguments.onlyOne((CommandElement)GenericArguments.user((Text)Text.of((String)"player")))), GenericArguments.optionalWeak((CommandElement)GenericArguments.onlyOne((CommandElement)new IpElement((Text)Text.of((String)"ip"))))}).executor((CommandExecutor)new LookupCommand()).build());
        children.put(Lists.newArrayList((Object[])new String[]{"history", "past", "dates"}), CommandSpec.builder().description((Text)Text.of((String)"Displays the login history of an IP or a player.")).permission("iplog.viewer.history").arguments(new CommandElement[]{GenericArguments.optionalWeak((CommandElement)GenericArguments.onlyOne((CommandElement)GenericArguments.user((Text)Text.of((String)"player")))), GenericArguments.optionalWeak((CommandElement)GenericArguments.onlyOne((CommandElement)new IpElement((Text)Text.of((String)"ip"))))}).executor((CommandExecutor)new HistoryCommand()).build());
        Sponge.getCommandManager().register((Object)this, (CommandCallable)CommandSpec.builder().description((Text)Text.of((String)"Displays basic information about the IPLog plugin.")).permission("iplog.viewer").executor((CommandExecutor)new BaseCommand()).children(children).build(), new String[]{"ip", "iplog", "ipregister"});
        this.logger.info("Commands have been successfully registered.");
    }

    public Path getParentPath() {
        return this.parentPath;
    }

    public Storage getStorage() {
        return this.storage;
    }

    public Logger getLogger() {
        return this.logger;
    }

    public PluginContainer getPluginContainer() {
        return this.pluginContainer;
    }

    public static IPLog getPlugin() {
        return plugin;
    }
}

