/*
 * Decompiled with CFR 0.152.
 */
package com.ichorpowered.iplog;

import com.ichorpowered.iplog.IPLog;
import java.net.InetAddress;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.time.LocalDateTime;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import org.spongepowered.api.Sponge;
import org.spongepowered.api.service.sql.SqlService;

public class Storage {
    private SqlService sql;

    public Storage() throws SQLException {
        this.createTables();
    }

    private Connection getConnection() throws SQLException {
        if (this.sql == null) {
            Optional optionalSql = Sponge.getServiceManager().provide(SqlService.class);
            if (optionalSql.isPresent()) {
                this.sql = (SqlService)optionalSql.get();
            } else {
                throw new SQLException("Sponge SQL service is missing.");
            }
        }
        return this.sql.getDataSource("jdbc:h2:" + IPLog.getPlugin().getParentPath().toAbsolutePath().toString() + "/storage.db").getConnection();
    }

    private void createTables() throws SQLException {
        try (Connection conn = this.getConnection();){
            conn.prepareStatement("CREATE TABLE IF NOT EXISTS REGISTRY( IP VARCHAR(45), ID CHAR(36), INSTANT DATETIME, PRIMARY KEY(IP, ID))").execute();
        }
    }

    /*
     * Exception decompiling
     */
    public boolean isPresent(InetAddress ip, UUID uuid) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public void addConnection(InetAddress ip, UUID uuid, LocalDateTime time) {
        try (Connection conn = this.getConnection();
             PreparedStatement ps = conn.prepareStatement("INSERT INTO REGISTRY(IP, ID, INSTANT) VALUES (?, ?, ?)");){
            ps.setString(1, ip.getHostAddress());
            ps.setString(2, uuid.toString());
            ps.setTimestamp(3, Timestamp.valueOf(time));
            ps.execute();
        }
        catch (SQLException e) {
            IPLog.getPlugin().getLogger().error("Failed to create new connection.");
            e.printStackTrace();
        }
    }

    public void updateConnection(InetAddress ip, UUID uuid, LocalDateTime time) {
        try (Connection conn = this.getConnection();
             PreparedStatement ps = conn.prepareStatement("UPDATE REGISTRY SET INSTANT = ? WHERE IP = ? AND ID = ?");){
            ps.setTimestamp(1, Timestamp.valueOf(time));
            ps.setString(2, ip.getHostAddress());
            ps.setString(3, uuid.toString());
            ps.execute();
        }
        catch (SQLException e) {
            IPLog.getPlugin().getLogger().error("Failed to update old connection.");
            e.printStackTrace();
        }
    }

    public void purgeConnection(InetAddress ip, UUID uuid) {
        try (Connection conn = this.getConnection();
             PreparedStatement ps = conn.prepareStatement("DELETE FROM REGISTRY WHERE IP = ? AND ID = ?");){
            ps.setString(1, ip.getHostAddress());
            ps.setString(2, uuid.toString());
            ps.execute();
        }
        catch (SQLException e) {
            IPLog.getPlugin().getLogger().error("Failed to purge connection.");
            e.printStackTrace();
        }
    }

    public Set<UUID> getAliases(UUID uuid) {
        HashSet<UUID> aliases = new HashSet<UUID>();
        try (Connection conn = this.getConnection();
             PreparedStatement ps = conn.prepareStatement("SELECT DISTINCT(REG.ID) FROM REGISTRY JOIN REGISTRY REG ON (REGISTRY.IP = REG.IP) WHERE REGISTRY.ID = ?");){
            ps.setString(1, uuid.toString());
            try (ResultSet rs = ps.executeQuery();){
                while (rs.next()) {
                    aliases.add(UUID.fromString(rs.getString(1)));
                }
            }
        }
        catch (SQLException e) {
            IPLog.getPlugin().getLogger().error("Failed to get all possible aliases of a player from storage.");
            e.printStackTrace();
        }
        return aliases;
    }

    public Set<UUID> getPlayers(InetAddress ip) {
        HashSet<UUID> players = new HashSet<UUID>();
        try (Connection conn = this.getConnection();
             PreparedStatement ps = conn.prepareStatement("SELECT ID FROM REGISTRY WHERE IP = ?");){
            ps.setString(1, ip.getHostAddress());
            try (ResultSet rs = ps.executeQuery();){
                while (rs.next()) {
                    players.add(UUID.fromString(rs.getString(1)));
                }
            }
        }
        catch (SQLException e) {
            IPLog.getPlugin().getLogger().error("Failed to get all players connected to this ip address.");
            e.printStackTrace();
        }
        return players;
    }

    public Set<String> getAddresses(UUID uuid) {
        HashSet<String> addresses = new HashSet<String>();
        try (Connection conn = this.getConnection();
             PreparedStatement ps = conn.prepareStatement("SELECT IP FROM REGISTRY WHERE ID = ?");){
            ps.setString(1, uuid.toString());
            try (ResultSet rs = ps.executeQuery();){
                while (rs.next()) {
                    addresses.add(rs.getString(1));
                }
            }
        }
        catch (SQLException e) {
            IPLog.getPlugin().getLogger().error("Failed to get all ip addresses connected to this uuid.");
            e.printStackTrace();
        }
        return addresses;
    }

    public Map<String, LocalDateTime> getAddressesAndTime(UUID uuid) {
        HashMap<String, LocalDateTime> data = new HashMap<String, LocalDateTime>();
        try (Connection conn = this.getConnection();
             PreparedStatement ps = conn.prepareStatement("SELECT IP, INSTANT FROM REGISTRY WHERE ID = ? ORDER BY INSTANT");){
            ps.setString(1, uuid.toString());
            try (ResultSet rs = ps.executeQuery();){
                while (rs.next()) {
                    data.put(rs.getString(1), rs.getTimestamp(2).toLocalDateTime());
                }
            }
        }
        catch (SQLException e) {
            IPLog.getPlugin().getLogger().error("Failed to get all ip addresses and dates connected to this uuid.");
            e.printStackTrace();
        }
        return data;
    }

    public Map<UUID, LocalDateTime> getPlayersAndTime(InetAddress ip) {
        HashMap<UUID, LocalDateTime> data = new HashMap<UUID, LocalDateTime>();
        try (Connection conn = this.getConnection();
             PreparedStatement ps = conn.prepareStatement("SELECT ID, INSTANT FROM REGISTRY WHERE IP = ? ORDER BY INSTANT");){
            ps.setString(1, ip.getHostAddress());
            try (ResultSet rs = ps.executeQuery();){
                while (rs.next()) {
                    data.put(UUID.fromString(rs.getString(1)), rs.getTimestamp(2).toLocalDateTime());
                }
            }
        }
        catch (SQLException e) {
            IPLog.getPlugin().getLogger().error("Failed to get all uuids and dates connected to this ip address.");
            e.printStackTrace();
        }
        return data;
    }
}

