/*
 * Decompiled with CFR 0.152.
 */
package com.ichorpowered.iplog.command;

import com.ichorpowered.iplog.IPLog;
import java.net.InetAddress;
import java.time.LocalDateTime;
import java.util.Optional;
import org.spongepowered.api.Sponge;
import org.spongepowered.api.command.CommandException;
import org.spongepowered.api.command.CommandResult;
import org.spongepowered.api.command.CommandSource;
import org.spongepowered.api.command.args.CommandContext;
import org.spongepowered.api.command.spec.CommandExecutor;
import org.spongepowered.api.entity.living.player.User;
import org.spongepowered.api.text.Text;
import org.spongepowered.api.text.format.TextColors;

public class AddCommand
implements CommandExecutor {
    public CommandResult execute(CommandSource src, CommandContext args) throws CommandException {
        Optional optionalUser = args.getOne("player");
        if (!optionalUser.isPresent()) {
            throw new CommandException(Text.of((Object[])new Object[]{TextColors.RED, "You must specify an existing user."}));
        }
        Optional optionalIP = args.getOne("ip");
        if (!optionalIP.isPresent()) {
            throw new CommandException(Text.of((Object[])new Object[]{TextColors.RED, "You must specify a proper IP address."}));
        }
        User user = (User)optionalUser.get();
        InetAddress ip = (InetAddress)optionalIP.get();
        if (IPLog.getPlugin().getStorage().isPresent(ip, user.getUniqueId())) {
            throw new CommandException(Text.of((Object[])new Object[]{TextColors.RED, "This connection already exists in the database."}));
        }
        Sponge.getScheduler().createAsyncExecutor((Object)IPLog.getPlugin()).execute(() -> IPLog.getPlugin().getStorage().addConnection(ip, user.getUniqueId(), LocalDateTime.now()));
        src.sendMessage(Text.of((Object[])new Object[]{TextColors.YELLOW, "You have successfully added the specified connection to the database."}));
        return CommandResult.success();
    }
}

