/*
 * Decompiled with CFR 0.152.
 */
package com.ichorpowered.iplog.command;

import com.ichorpowered.iplog.IPLog;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.stream.Collectors;
import org.spongepowered.api.Sponge;
import org.spongepowered.api.command.CommandException;
import org.spongepowered.api.command.CommandResult;
import org.spongepowered.api.command.CommandSource;
import org.spongepowered.api.command.args.CommandContext;
import org.spongepowered.api.command.spec.CommandExecutor;
import org.spongepowered.api.entity.living.player.User;
import org.spongepowered.api.service.pagination.PaginationService;
import org.spongepowered.api.service.user.UserStorageService;
import org.spongepowered.api.text.Text;
import org.spongepowered.api.text.channel.MessageReceiver;
import org.spongepowered.api.text.format.TextColors;

public class AliasCommand
implements CommandExecutor {
    public CommandResult execute(CommandSource src, CommandContext args) throws CommandException {
        Optional optionalUser = args.getOne("player");
        if (!optionalUser.isPresent()) {
            throw new CommandException(Text.of((Object[])new Object[]{TextColors.RED, "You must specify an existing user."}));
        }
        User user = (User)optionalUser.get();
        Sponge.getScheduler().createAsyncExecutor((Object)IPLog.getPlugin()).execute(() -> {
            UUID sender;
            Set<UUID> users = IPLog.getPlugin().getStorage().getAliases(user.getUniqueId());
            if (src instanceof User && (sender = ((User)src).getUniqueId()).equals(user.getUniqueId())) {
                users.remove(sender);
            }
            if (users.size() == 0) {
                src.sendMessage(Text.of((Object[])new Object[]{TextColors.RED, "There are no aliases associated with the specified user."}));
                return;
            }
            Sponge.getScheduler().createSyncExecutor((Object)IPLog.getPlugin()).execute(() -> {
                UserStorageService userStorageService = (UserStorageService)Sponge.getServiceManager().provide(UserStorageService.class).get();
                ((PaginationService)Sponge.getServiceManager().provide(PaginationService.class).get()).builder().title(Text.of((Object[])new Object[]{TextColors.DARK_GREEN, "Aliases of ", TextColors.GREEN, user.getName()})).contents((Iterable)users.stream().map(arg_0 -> ((UserStorageService)userStorageService).get(arg_0)).filter(Optional::isPresent).map(Optional::get).map(User::getName).map(Text::of).map(username -> Text.of((Object[])new Object[]{TextColors.DARK_GREEN, username})).collect(Collectors.toList())).linesPerPage(14).padding(Text.of((Object[])new Object[]{TextColors.GRAY, "="})).sendTo((MessageReceiver)src);
            });
        });
        return CommandResult.success();
    }
}

