/*
 * Decompiled with CFR 0.152.
 */
package com.ichorpowered.iplog.command;

import java.util.ArrayList;
import org.spongepowered.api.Sponge;
import org.spongepowered.api.command.CommandException;
import org.spongepowered.api.command.CommandResult;
import org.spongepowered.api.command.CommandSource;
import org.spongepowered.api.command.args.CommandContext;
import org.spongepowered.api.command.spec.CommandExecutor;
import org.spongepowered.api.service.pagination.PaginationList;
import org.spongepowered.api.service.pagination.PaginationService;
import org.spongepowered.api.text.Text;
import org.spongepowered.api.text.action.ClickAction;
import org.spongepowered.api.text.action.HoverAction;
import org.spongepowered.api.text.action.TextActions;
import org.spongepowered.api.text.channel.MessageReceiver;
import org.spongepowered.api.text.format.TextColors;

public class HelpCommand
implements CommandExecutor {
    public CommandResult execute(CommandSource src, CommandContext args) throws CommandException {
        HelpCommand.getPaginationList().sendTo((MessageReceiver)src);
        return CommandResult.success();
    }

    private static Text formatHelpText(String command, String description, Text extendedDescription) {
        return Text.of((Object[])new Object[]{Text.builder((String)command).color(TextColors.GREEN).onClick((ClickAction)TextActions.suggestCommand((String)command)).onHover((HoverAction)TextActions.showText((Text)extendedDescription)).build(), Text.of((Object[])new Object[]{TextColors.GRAY, " - ", description})});
    }

    private static PaginationList getPaginationList() {
        ArrayList<Text> contents = new ArrayList<Text>();
        contents.add(HelpCommand.formatHelpText("/ip", "Displays basic information about IPLog.", (Text)Text.of((String)"IPLog v0.2.0")));
        contents.add(HelpCommand.formatHelpText("/ip help", "Displays this page, giving information about IPLog commands.", (Text)Text.of((String)"Click here for IPLog help")));
        contents.add(HelpCommand.formatHelpText("/ip alias [player]", "Shows all possible players associated with this player.", (Text)Text.of((String)"Good for finding alternate accounts")));
        contents.add(HelpCommand.formatHelpText("/ip lookup [player]", "Lists all the IPs associated with the specified player.", (Text)Text.of((String)"Can also be used with IPs")));
        contents.add(HelpCommand.formatHelpText("/ip lookup [ip]", "Lists all the players associated with the specified IP.", (Text)Text.of((String)"Can also be used with users")));
        contents.add(HelpCommand.formatHelpText("/ip history [player]", "Displays all IPs associated with a player and their last date of login", (Text)Text.of((String)"Can also be used with IPs")));
        contents.add(HelpCommand.formatHelpText("/ip history [ip]", "Displays all users associated with an IP and their last date of login", (Text)Text.of((String)"Can also be used with users")));
        contents.add(HelpCommand.formatHelpText("/ip add [player] [ip]", "Adds a connection between a player and an IP", (Text)Text.of((String)"You must specify both")));
        contents.add(HelpCommand.formatHelpText("/ip purge [player] [ip]", "Removes the connection between a player and an IP", (Text)Text.of((String)"You must specify both")));
        return ((PaginationService)Sponge.getServiceManager().provide(PaginationService.class).get()).builder().title(Text.of((Object[])new Object[]{TextColors.DARK_GREEN, "IPLog Help"})).linesPerPage(14).padding(Text.of((Object[])new Object[]{TextColors.GRAY, "="})).contents(contents).build();
    }
}

