/*
 * Decompiled with CFR 0.152.
 */
package com.ichorpowered.iplog.command;

import com.ichorpowered.iplog.IPLog;
import java.net.InetAddress;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.time.temporal.TemporalAccessor;
import java.util.ArrayList;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import org.spongepowered.api.Sponge;
import org.spongepowered.api.command.CommandException;
import org.spongepowered.api.command.CommandResult;
import org.spongepowered.api.command.CommandSource;
import org.spongepowered.api.command.args.CommandContext;
import org.spongepowered.api.command.spec.CommandExecutor;
import org.spongepowered.api.entity.living.player.User;
import org.spongepowered.api.service.pagination.PaginationService;
import org.spongepowered.api.service.user.UserStorageService;
import org.spongepowered.api.text.Text;
import org.spongepowered.api.text.action.ClickAction;
import org.spongepowered.api.text.action.HoverAction;
import org.spongepowered.api.text.action.TextActions;
import org.spongepowered.api.text.channel.MessageReceiver;
import org.spongepowered.api.text.format.TextColors;

public class HistoryCommand
implements CommandExecutor {
    private static final Text PURGE = Text.of((Object[])new Object[]{TextColors.DARK_GRAY, "[", TextColors.RED, "-", TextColors.DARK_GRAY, "]"}).toBuilder().onHover((HoverAction)TextActions.showText((Text)Text.of((Object[])new Object[]{TextColors.RED, "Purges this IP-User connection."}))).build();
    private static final DateTimeFormatter TIME_FORMATTER = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm");

    public CommandResult execute(CommandSource src, CommandContext args) throws CommandException {
        Optional optionalUser = args.getOne("player");
        Optional optionalAddress = args.getOne("ip");
        if (optionalUser.isPresent() && optionalAddress.isPresent()) {
            throw new CommandException(Text.of((Object[])new Object[]{TextColors.RED, "You must specify either an IP address or player, but not both."}));
        }
        if (optionalAddress.isPresent()) {
            Sponge.getScheduler().createAsyncExecutor((Object)IPLog.getPlugin()).execute(() -> {
                Map<UUID, LocalDateTime> users = IPLog.getPlugin().getStorage().getPlayersAndTime((InetAddress)optionalAddress.get());
                if (users.isEmpty()) {
                    src.sendMessage(Text.of((Object[])new Object[]{TextColors.RED, "There are no players associated with this IP address."}));
                    return;
                }
                Sponge.getScheduler().createSyncExecutor((Object)IPLog.getPlugin()).execute(() -> {
                    UserStorageService userStorageService = (UserStorageService)Sponge.getServiceManager().provide(UserStorageService.class).get();
                    ArrayList contents = new ArrayList();
                    users.forEach((key, value) -> userStorageService.get(key).ifPresent(user -> contents.add(Text.of((Object[])new Object[]{TextColors.DARK_GREEN, user.getName(), TextColors.GRAY, "    ", TIME_FORMATTER.format((TemporalAccessor)value), "          ", PURGE.toBuilder().onClick((ClickAction)TextActions.suggestCommand((String)("/ip purge " + user.getName() + " " + ((InetAddress)optionalAddress.get()).getHostAddress())))}))));
                    ((PaginationService)Sponge.getServiceManager().provide(PaginationService.class).get()).builder().title(Text.of((Object[])new Object[]{TextColors.DARK_GREEN, "User History Associated With ", TextColors.GREEN, ((InetAddress)optionalAddress.get()).getHostAddress()})).contents(contents).linesPerPage(14).padding(Text.of((Object[])new Object[]{TextColors.GRAY, "="})).sendTo((MessageReceiver)src);
                });
            });
        } else if (optionalUser.isPresent()) {
            Sponge.getScheduler().createAsyncExecutor((Object)IPLog.getPlugin()).execute(() -> {
                Map<String, LocalDateTime> addresses = IPLog.getPlugin().getStorage().getAddressesAndTime(((User)optionalUser.get()).getUniqueId());
                if (addresses.isEmpty()) {
                    src.sendMessage(Text.of((Object[])new Object[]{TextColors.RED, "There are no IP addresses associated with this user."}));
                    return;
                }
                ArrayList contents = new ArrayList();
                addresses.forEach((key, value) -> contents.add(Text.of((Object[])new Object[]{TextColors.DARK_GREEN, key, "    ", TextColors.GRAY, TIME_FORMATTER.format((TemporalAccessor)value), "          ", PURGE.toBuilder().onClick((ClickAction)TextActions.suggestCommand((String)("/ip purge " + ((User)optionalUser.get()).getName() + " " + key)))})));
                ((PaginationService)Sponge.getServiceManager().provide(PaginationService.class).get()).builder().title(Text.of((Object[])new Object[]{TextColors.DARK_GREEN, "IP History Associated With ", TextColors.GREEN, ((User)optionalUser.get()).getName()})).contents(contents).linesPerPage(14).padding(Text.of((Object[])new Object[]{TextColors.GRAY, "="})).sendTo((MessageReceiver)src);
            });
        } else {
            throw new CommandException(Text.of((Object[])new Object[]{TextColors.RED, "You must specify either an IP address or a player."}));
        }
        return CommandResult.success();
    }
}

