/*
 * Decompiled with CFR 0.152.
 */
package com.ichorpowered.iplog.command;

import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.List;
import org.spongepowered.api.command.CommandSource;
import org.spongepowered.api.command.args.ArgumentParseException;
import org.spongepowered.api.command.args.CommandArgs;
import org.spongepowered.api.command.args.CommandContext;
import org.spongepowered.api.command.args.CommandElement;
import org.spongepowered.api.text.LiteralText;
import org.spongepowered.api.text.Text;
import org.spongepowered.api.text.format.TextColors;

public class IpElement
extends CommandElement {
    private static Text IP = LiteralText.of((String)"<ip address>");
    private static List<String> EMPTY_LIST = new ArrayList<String>();

    public IpElement(Text key) {
        super(key);
    }

    protected Object parseValue(CommandSource source, CommandArgs args) throws ArgumentParseException {
        if (!args.hasNext()) {
            throw args.createError(Text.of((Object[])new Object[]{TextColors.RED, "You must specify an IP address."}));
        }
        try {
            return InetAddress.getByName(args.next());
        }
        catch (UnknownHostException e) {
            throw args.createError(Text.of((Object[])new Object[]{TextColors.RED, "This is not a valid IP address."}));
        }
    }

    public List<String> complete(CommandSource src, CommandArgs args, CommandContext context) {
        return EMPTY_LIST;
    }

    public Text getUsage(CommandSource src) {
        return IP;
    }
}

