/*
 * Decompiled with CFR 0.152.
 */
package com.ichorpowered.iplog.command;

import com.ichorpowered.iplog.IPLog;
import java.net.InetAddress;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.stream.Collectors;
import org.spongepowered.api.Sponge;
import org.spongepowered.api.command.CommandException;
import org.spongepowered.api.command.CommandResult;
import org.spongepowered.api.command.CommandSource;
import org.spongepowered.api.command.args.CommandContext;
import org.spongepowered.api.command.spec.CommandExecutor;
import org.spongepowered.api.entity.living.player.User;
import org.spongepowered.api.service.pagination.PaginationService;
import org.spongepowered.api.service.user.UserStorageService;
import org.spongepowered.api.text.Text;
import org.spongepowered.api.text.channel.MessageReceiver;
import org.spongepowered.api.text.format.TextColors;

public class LookupCommand
implements CommandExecutor {
    public CommandResult execute(CommandSource src, CommandContext args) throws CommandException {
        Optional optionalUser = args.getOne("player");
        Optional optionalAddress = args.getOne("ip");
        if (optionalUser.isPresent() && optionalAddress.isPresent()) {
            throw new CommandException(Text.of((Object[])new Object[]{TextColors.RED, "You must specify either an IP address or player, but not both."}));
        }
        if (optionalAddress.isPresent()) {
            Sponge.getScheduler().createAsyncExecutor((Object)IPLog.getPlugin()).execute(() -> {
                Set<UUID> users = IPLog.getPlugin().getStorage().getPlayers((InetAddress)optionalAddress.get());
                if (users.isEmpty()) {
                    src.sendMessage(Text.of((Object[])new Object[]{TextColors.RED, "There are no users associated with this IP address."}));
                    return;
                }
                UserStorageService userStorageService = (UserStorageService)Sponge.getServiceManager().provide(UserStorageService.class).get();
                Sponge.getServiceManager().provide(PaginationService.class).ifPresent(p -> p.builder().title(Text.of((Object[])new Object[]{TextColors.DARK_GREEN, "Users Associated With ", TextColors.GREEN, ((InetAddress)optionalAddress.get()).getHostAddress()})).contents((Iterable)users.stream().map(arg_0 -> ((UserStorageService)userStorageService).get(arg_0)).filter(Optional::isPresent).map(Optional::get).map(User::getName).map(Text::of).map(username -> Text.of((Object[])new Object[]{TextColors.DARK_GREEN, username})).collect(Collectors.toList())).linesPerPage(14).padding(Text.of((Object[])new Object[]{TextColors.GRAY, "="})).sendTo((MessageReceiver)src));
            });
        } else if (optionalUser.isPresent()) {
            Sponge.getScheduler().createAsyncExecutor((Object)IPLog.getPlugin()).execute(() -> {
                Set<String> ips = IPLog.getPlugin().getStorage().getAddresses(((User)optionalUser.get()).getUniqueId());
                if (ips.isEmpty()) {
                    src.sendMessage(Text.of((Object[])new Object[]{TextColors.RED, "There are no IP addresses associated with this user."}));
                    return;
                }
                ((PaginationService)Sponge.getServiceManager().provide(PaginationService.class).get()).builder().title(Text.of((Object[])new Object[]{TextColors.DARK_GREEN, "IPs Associated With ", TextColors.GREEN, ((User)optionalUser.get()).getName()})).contents((Iterable)ips.stream().map(ip -> Text.of((Object[])new Object[]{TextColors.DARK_GREEN, ip})).collect(Collectors.toList())).linesPerPage(14).padding(Text.of((Object[])new Object[]{TextColors.GRAY, "="})).sendTo((MessageReceiver)src);
            });
        } else {
            throw new CommandException(Text.of((Object[])new Object[]{TextColors.RED, "You must specify either an IP address or a player."}));
        }
        return CommandResult.success();
    }
}

